<?



# ==================================================================================
# 
# Listado de Contratos del Socio
# contracts=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"}
# 
# ==================================================================================

logDebug($debug,"", __LINE__, __FILE__);

$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

$data_id_cliente = trim($data["id_cliente"]);

// verifica si el json es valido
if ($jsonerror){
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}

logDebug($debug,"", __LINE__, __FILE__);

// verifica si ingresa el dato id_cliente - proceso principal
if ($data_id_cliente){

	$sql = "SELECT c.*, 
					ct.Descripcion AS Contrato_Descripcion1, 
					dbo.CF_Contrato_Descrip(c.Id_Contrato) AS Contrato_Descripcion,
					Tar.Descrip_Corta AS Tarjeta_Descrip_Corta
				FROM contratos c
					LEFT JOIN Contratos_Tipos ct		ON c.Id_Tipo_Con	=	ct.Id_Tipo_Con
					LEFT JOIN Valores_Tarjetas_Cred Tar ON c.Id_Tarjeta		=	Tar.Id_Tarjeta
				WHERE c.Activo=1
				AND ISNULL(Fecha_Hasta,GETDATE() + 1) > GETDATE()
				AND ct.Flag_Web = 1
				and c.Id_Cliente = ?";


	$params = array($data_id_cliente);
  	$stmt = sqlsrv_query( $conn, $sql, $params);
  	log_query($sql, $params);
	if( $stmt === false ) {
  	    sql_error(sqlsrv_errors(), "Error 5744763" , __LINE__, __FILE__ );
	}else{
  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
  			$contracts[] = $row;
  		}
  	}
	
		$resp = array("data" => array("contracts" => $contracts), "status" => 200, "message" => "");
		echo json_encode($resp);
		exit;
	
}


// final de codigo - error
$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
echo json_encode($res);
exit;



?>