<?

/*
<clever-autodoc>
	<file name="sca_api_megatlon.php">
		<name>sca_api_megatlon.php</name>
		<last_update>03/12/2019 10:23Hs</last_update>
		<updates>
			<item>
				<date>03/12/2019 10:23</date>
				<description>Creacion del archivo</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>API_Megatlon_Validar_Socio</name>
				<description>Invoca al metodo "GetBasic" de la API de Megatlon para validar si un socio esta Activo</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/


/*
<clever-autodoc>
	<function name="API_Megatlon_Validar_Socio">
		<name>API_Megatlon_Validar_Socio</name>
		<description>Invoca al metodo "GetBasic" de la API de Megatlon para validar si un socio esta Activo</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente el cual se quieren validar si esta Activo</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
				<item>
					<id>406</id>
					<description>No hay token habilitado</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>SocioHabilitado</name>
					<type>TINYINT</type>
					<description>1: El socio esta habilitado. 0: El socio no esta habilitado</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*API_Megatlon_Validar_Socio INICIO*/
if ($_POST["API_Megatlon_Validar_Socio"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("API_Megatlon_Validar_Socio: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_Cliente"];	

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente > 0){
		
		$sql = "SELECT ISNULL(Doc_Nro, 0) AS Doc_Nro, dbo.CF_AR_MEGATLON_WS_Token_Acceso_Token_Activo() AS Token_Megatlon, dbo.CF_xParam('WS_Megatlon_Url') AS UrlAPI FROM Clientes WHERE Id_Cliente = ?";
		$params = array($pId_Cliente);
	  	$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("API_Megatlon_Validar_Socio: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("API_Megatlon_Validar_Socio: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$doc_Nro = $row["Doc_Nro"];			
			$token = $row["Token_Megatlon"];
			$urlAPI = $row["UrlAPI"];
			
			if($token)
			{
				//A partir de la consulta del Documento ahora valida en la API de Megatlon
				$parametros_get = "?TipoDocumento=1&NumeroDocumento=".$doc_Nro;			
				$handle = curl_init();
				curl_setopt($handle, CURLOPT_URL, $urlAPI.'Tienda/Socio/GetBasic'.$parametros_get); 
				curl_setopt($handle, CURLOPT_PORT, 443);
				curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($handle, CURLOPT_CUSTOMREQUEST, "GET");
				curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);				
				curl_setopt($handle, CURLOPT_HTTPHEADER, array("Authorization: Bearer ".$token));
				$rtaAPIMegatlon = trim(curl_exec($handle));
				//print_r(curl_getinfo($handle));					// Debug Curl
				curl_close($handle);

				if($rtaAPIMegatlon === '"Socio no encontrado"')
				{
					$rtaCleverSoft = array("SocioHabilitado" => 0);
				}
				else
				{
					$arrayRtaAPIMegatlon = json_decode($rtaAPIMegatlon, true);
					if($arrayRtaAPIMegatlon["sucursal"] === 'N/A')
					{
						$rtaCleverSoft = array("SocioHabilitado" => 0);
					}
					else
					{
						$rtaCleverSoft = array("SocioHabilitado" => 1);
					}
				}
				
				$res = array("data" => $rtaCleverSoft, "status" => 200, "message" => "");
				echo json_encode($res);
				exit;
			}else{
				logError("API_Megatlon_Validar_Socio: No hay un Token de Acceso valido. Verifique que el servicio de peticion de Token se encuentre ejecutando", __LINE__);
				$res = array("data" => "", "status" => 406, "message" => "No hay un Token de Acceso valido. Verifique que el servicio de peticion de Token se encuentre ejecutando");
				echo json_encode($res);
				exit;
			}
	  	}	
	}else{
		logError("API_Megatlon_Validar_Socio: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*API_Megatlon_Validar_Socio FIN*/


?>