<?



# ==================================================================================
# 
# Listado de Turnos del mes
# shifts_month=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"anio" => 2020 , ["mes"] => 3}
# 
# ==================================================================================



$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

$data_anio = trim($data["anio"]);
$data_mes = trim($data["mes"]);

// verifica si el json es valido
if ($jsonerror){
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}

if ($data_anio && $data_mes){


	$sql = "SELECT * FROM CRM_Turnos WHERE YEAR(Fecha)=? AND MONTH(Fecha)=? AND Activo=1";
	$params = array($data_anio, $data_mes);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	if( $stmt === false ) {
  	    sql_error(sqlsrv_errors(), "ERROR: CSSM 00100" , __LINE__, __FILE__ );
	}else{
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			$turnos[] = $row;
		}
  		$resp = array("data" => array("turnos" => $turnos), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
	}

}

// final de codigo - error
$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
echo json_encode($res);
exit;



?>