<?
# ==================================================================================
# 
# Listado de Contactos del Cliente CRM (ultimos 25)
# crm_contacts=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente" => 0, "tipo" => 0}
# 
# estado 0 : abiertos
# estado 1 : cerrados
# ==================================================================================

$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

$data_id_cliente = trim($data["id_cliente"]);
$data_estado = trim($data["estado"]);

// verifica si el json es valido
if ($jsonerror){
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}

if ($data_id_cliente){

	$sql = "SELECT c.*, cm.Descripcion as motivo_desc, csm.Descripcion as sub_motivo_desc
			FROM CRM_Contactos c
			LEFT JOIN CRM_Cont_Motivos		cm	on 	c.Id_SubMotivo_Contacto = cm.Id_Motivo_Contacto
			LEFT JOIN CRM_Cont_SubMotivos   csm on 	c.Id_Motivo_Contacto 	= csm.Id_Motivo_Contacto 
												AND c.Id_SubMotivo_Contacto = csm.Id_SubMotivo_Contacto
			WHERE c.Modo = 'E' AND c.Id_Tipo_Contacto = CAST(dbo.CF_xParam('CRM_Tipo_Cont_Web') AS INT)
			AND c.Id_Cliente = ? ";
	if ($data_estado==1)	// Abierto
		$sql .= " AND c.Fecha_Reso IS NULL ";
	if ($data_estado==2)	// Cerrados
		$sql .= " AND c.Fecha_Reso IS NOT NULL ";
	$sql .= " ORDER BY c.FECHA DESC ";

	$params = array($data_id_cliente);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	//log_query($sql, $params);
	if( $stmt === false ) {
  	    sql_error(sqlsrv_errors(), "Error 008765420" , __LINE__, __FILE__ );
	}else{
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			$crm_contacts[] = $row;
		}
  		$resp = array("data" => array("crm_contacts" => $crm_contacts), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
	}

}

// final de codigo - error
$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
echo json_encode($res);
exit;




?>