<?

/*
<clever-autodoc>
	<function name="api_sqlsrv_query">
		<name>api_sqlsrv_query</name>
		<description>Ejecuta un query genérico</description>
		<parameters>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Generico</name>
					<type>GENERICO</type>
					<description>Generico dependiendo del Query enviado</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*api_sqlsrv_query INCIO*/



	
$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

//Verifica si en "data" el fomato JSON es valido
if ($jsonerror){
	logError("sqlsrv_query: JSON Data Invalido", __LINE__);
	$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
	echo json_encode($res);
	exit;
}

$pQuery = $data["pQuery"];
	
//Verifica si los valores enviados en los parametros de Data contiene algun valor
if ($pQuery){
	
	$sql = $pQuery;
  	$stmt = sqlsrv_query( $conn, $sql );

  	//Verifica si hay algun error al ejecutar la consulta
  	if( $stmt === false ) {
		sql_error(sqlsrv_errors(), "CSQ 00100" , __LINE__, __FILE__ );
  	}else{
		//Resultado consulta SQL OK
		
		if(substr($sql , 0, 4) == "EXEC")
		{
			/*Es un Stored Procedures*/
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
		}
		else
		{
			/*Es un Query Tipo SELECT*/
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$res[] = $row;
			}
		}

		$resp = array("data" => $res, "status" => 200, "message" => "");			
		echo json_encode($resp);			
		exit;	  		
  	}	
}else{
	logError("sqlsrv_query: Valores Parametros Data Invalido", __LINE__);
	$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
	echo json_encode($res);
	exit;
}	
/*api_sqlsrv_query FIN*/



?>