<?

/*
TURNOS:
- getTurnosCliente				Listado de Turnos de un cliente
- cancelTurno					Cancela el turno del socio
- turnosTipos					Listado de Turnos Tipos
- getTurnosMes					Listado de Turnos del mes
- confirmaTurno					Confirmar turno del cliente




*/



# ==================================================================================
# 
# Guarda tipo de turno 
# setCrmTipoTurno=1
# 
# ==================================================================================
# 
# data (POST)
# 	{$descripcion, $frecuencia, $dias_futuro, $semana, $hora_inicio, $minutos_inicio, $hora_fin, $minutos_fin, $mails, $minutos_anticipacion, $turnos_dia: ...}
# ==================================================================================

if ($_POST["setCrmTipoTurno"]==1){


	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	$data_descripcion= trim($data["descripcion"]);
	$data_frecuencia = trim($data["frecuencia"]);
	$data_dias_futuro = trim($data["dias_futuro"]);
	$data_semana= trim($data["semana"]);
	$data_hora_inicio = trim($data["hora_inicio"]);
	//$data_minutos_inicio = trim($data["minutos_inicio"]);
	$data_hora_fin= trim($data["hora_fin"]);
	//$data_minutos_fin = trim($data["minutos_fin"]);
	$data_emails = trim($data["emails"]);
	$data_minutos_anticipacion = trim($data["minutos_anticipacion"]);
	$data_turnos_dia = trim($data["turnos_dia"]);

	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_descripcion){
		$sql = "SELECT ISNULL(MAX(ISNULL(Id_Turno_Tipo,0)),0) as num FROM CRM_Turnos_Tipos";
		$stmt = sqlsrv_query( $conn, $sql);
		if($stmt) {
			$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
			$Id_Turno_Tipo = $row["num"] + 1;
		}

		if ($Id_Turno_Tipo){
			$sql = "INSERT INTO CRM_Turnos_Tipos 
				(descripcion, frecuencia, dias_futuro, semana, hora_inicio, hora_fin, emails, minutos_anticipacion,turnos_dia, activo)
				VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 1)";
			$params = array( $data_descripcion, $data_frecuencia, $data_dias_futuro, $data_semana, $data_hora_inicio, 
								$data_hora_fin, $data_emails, $data_minutos_anticipacion, $data_turnos_dia,1);
			$stmt = sqlsrv_query( $conn, $sql, $params);
			if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 410, "message" => ("Error 4875943: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	logError("Error sql 4875945", __LINE__);
					$res = array("data" => "", "status" => 420, "message" => "Error 8573987");
		  			echo json_encode($res);
		  			exit;
		  	    }
			}else{
	
		  		$resp = array("data" => array(), "status" => 200, "message" => "");
		  		echo json_encode($resp);
		  		exit;
		  		
			}
		}else{
  	    	logError("Error sql 4875693", __LINE__);
			$res = array("data" => "", "status" => 430, "message" => "Error 4875693");
  			echo json_encode($res);
  			exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 440, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}









# ==================================================================================
# 
# Listado de getTurnos del Cliente (ultimos 25)
# getTurnosCliente=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente" => 0}
# 
# ==================================================================================

if ($_POST["getTurnosCliente"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = trim($data["id_cliente"]);

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_id_cliente){

	
		$sql = "SELECT top 20 * from CRM_Turnos WHERE Id_Cliente=? AND Activo=1 ORDER BY Fecha ASC";
		$params = array($data_id_cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$turnos[] = $row;
			}
	  		$resp = array("data" => array("turnos" => $turnos), "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}






# ==================================================================================
# 
# Cancela un turno
# cancelTurno=1
# 
# ==================================================================================
# 
# data (POST)
# 	{}
# 
# ==================================================================================

if ($_POST["cancelTurno"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = trim($data["id_cliente"]);
	$data_id_turno = trim($data["id_turno"]);

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_id_cliente && $data_id_turno){

	
		$sql = "UPDATE CRM_Turnos SET Activo=0 WHERE Id_Cliente=? AND Id_Turno=? ";
		$params = array($data_id_cliente, $data_id_turno);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			//	$turnos[] = $row;
			//}
	  		$resp = array("data" => array("turno" => $data_id_turno), "status" => 200, "message" => "Turno Cancelado");
	  		echo json_encode($resp);
	  		exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}






# ==================================================================================
# 
# Listado de tipos de turnos Turnos_Tipos
# turnosTipos=1
# 
# ==================================================================================
# 
# data (POST)
# 	{}
# 
# ==================================================================================

if ($_POST["turnosTipos"]==1){
	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = trim($data["id_cliente"]);


	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	
  	$sql = "SELECT Id_Turno_Tipo, Id_Usuario, Descripcion, Frecuencia, Minutos_Anticipacion, Emails, Hora_Fin, Hora_Inicio, Turnos_Dia, Dias_Futuro, 
				Concat (isnull(domingo,0),isnull(lunes,0), isnull(martes,0),isnull(miercoles,0),isnull(jueves,0),isnull(viernes,0),isnull(sabado,0)) as 'Semana'
			FROM CRM_Turnos_Tipos CT
			WHERE CT.Activo=1 AND Id_Turno_Tipo not in (SELECT Id_Turno_Tipo FROM CRM_Turnos WHERE Id_Cliente= ? and activo=1)";
  	$params = array($data_id_cliente);
	
  	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	logError("Error sql 8573987", __LINE__);
			$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
  			$Turnos_Tipos[$row["Id_Turno_Tipo"]] = $row;
  		}
  		$resp = array("data" => array("Turnos_Tipos" => $Turnos_Tipos), "status" => 200, "message" => "Turno Cancelado");
  		echo json_encode($resp);
  		exit;
  	}



	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}













# ==================================================================================
# 
# Listado de Turnos del mes
# getTurnosMes=1
# 
# ==================================================================================
# 
# data (POST)
# 	{}
# 
# ==================================================================================

if ($_POST["getTurnosMes"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_anio = trim($data["anio"]);
	$data_mes = trim($data["mes"]);

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_anio && $data_mes){

	
		$sql = "SELECT * FROM CRM_Turnos WHERE YEAR(Fecha)=? AND MONTH(Fecha)=? AND Activo=1";
		$params = array($data_anio, $data_mes);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$turnos[] = $row;
			}
	  		$resp = array("data" => array("turnos" => $turnos), "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}








# ==================================================================================
# 
# Confirma un turno
# confirmaTurno=1
# 
# ==================================================================================
# 
# data (POST)
# 	{id_cliente, id_turno_tipo, descripcion, anio, mes, dia, hora, minutos, email}
# 
# ==================================================================================

if ($_POST["confirmaTurno"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = $data["id_cliente"];
	$data_id_turno_tipo = $data["id_turno_tipo"];
	$data_descripcion = trim($data["descripcion"]);
	
	$data_anio = (int)$data["anio"];
	$data_mes = (int)$data["mes"];
	$data_dia = (int)$data["dia"];
	$data_hora = (int)$data["hora"];
	$data_minutos = (int)$data["minutos"];
	
	$data_email = trim($data["email"]);

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_id_cliente && $data_id_turno_tipo && $data_anio && $data_mes && $data_dia){

		// VERIFICO SI YA ESTA TOMADO...
		$cant = 0;
		$sql = "SELECT * FROM CRM_Turnos WHERE YEAR(Fecha)=? AND MONTH(Fecha)=? AND DAY(Fecha)=? AND DATEPART(hour, Fecha)=? AND DATEPART(minute, Fecha)=? AND Activo=1";
		$params = array($data_anio, $data_mes, $data_dia, $data_hora, $data_minutos);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$cant++;
			}
			// SI NO ESTA TOMADO LO INGRESO A LA DB
			if ($cant==0){
				$fecha = $data_anio . str_pad($data_mes, 2, "0", STR_PAD_LEFT) . str_pad($data_dia, 2, "0", STR_PAD_LEFT) . " " . str_pad($data_hora, 2, "0", STR_PAD_LEFT) . ":" . str_pad($data_minutos, 2, "0", STR_PAD_LEFT);
				$sql = "INSERT INTO CRM_Turnos (Id_Cliente, Id_Turno_Tipo, Fecha, Descripcion, Activo) values (?, ?, ?, ?, 1)";
				$params = array($data_id_cliente, $data_id_turno_tipo, $fecha, $data_descripcion);
				$stmt = sqlsrv_query( $conn, $sql, $params);
				if( $stmt === false ) {
			  	    if(($errors = sqlsrv_errors()) != null){
			  	    	logError("Error: " . $errors[0]["message"], __LINE__);
			  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
			  			echo json_encode($res);
			  			exit;
			  	    }else{
			  	    	logError("Error sql 8573987", __LINE__);
						$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
			  			echo json_encode($res);
			  			exit;
			  	    }
				}else{
				  	$res = array("data" => "", "status" => 200, "message" => "");
				  	echo json_encode($res);
				  	exit;					
				}
			}else{
				$res = array("data" => "", "status" => 401, "message" => "Turno no disponible");
			  	echo json_encode($res);
			  	exit;
			}
		}
	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}








# ==================================================================================

?>