<?


class ThumbHandle { 

	var $width; 
	var $height; 


	function ThumbHandle($width, $height) { 
		$this->width = $width; 
		$this->height = $height; 
	} 


	function generateJPEG($imageName, $originalPath, $destinationPath, $destinationName=''){ 
	
		$type = strtolower(get_ext($imageName));
		
		if ($type =="jpeg" || $type =="jpg") { 
			$srcimg = imagecreatefromjpeg($originalPath.$imageName) or die("Problem In opening Source Image 8373"); 
		} elseif ($type =="gif") {
			$srcimg = imagecreatefromgif($originalPath.$imageName) or die("Problem In opening Source Image 8374"); 
		} elseif ($type =="png") {
			$srcimg = imagecreatefrompng($originalPath.$imageName) or die("Problem In opening Source Image 8375"); 
		} elseif ($type =="bmp") {
			$srcimg = ImageCreateFromBMP($originalPath.$imageName) or die("Problem In opening Source Image 8376"); 
			//$srcimg = imagecreatefromwbmp($originalPath.$imageName) or die("Problem In opening Source Image 8376"); 
		} else {
			return; 
		}
	
	
	
	
	
		$src_w = imagesx($srcimg);
		$src_h = imagesy($srcimg);
		
		$des_w = $this->width;
		$des_h = $this->height;
		
		if ($des_w==0) $des_w = $src_w;
		if ($des_h==0) $des_h = $src_h;
		
		if ($des_w>$src_w && $des_h>$src_h){
			$des_w=$src_w;
			$des_h=$src_h;
		}else{
			if (($src_w/$des_w)>($src_h/$des_h)){
				$des_h=$src_h/($src_w/$des_w);
			}else{
				$des_w=$src_w/($src_h/$des_h);
			}
		}
	
		$destimg = imagecreatetruecolor($des_w, $des_h) or die("Problem In Creating image"); 

		if ($type=="gif") {	// transparencia para gif
			$idColorTransparente = imagecolorallocatealpha($destimg, 255, 255, 255, 127);
			imagefill($destimg, 0, 0, $idColorTransparente);
			imagecolortransparent($destimg, $idColorTransparente);
		}
		if ($type=="png") {	// transparencia para png
	        imagealphablending($destimg, false);
	        imagesavealpha($destimg,true);
	        $transparent = imagecolorallocatealpha($destimg, 255, 255, 255, 127);
	        imagefilledrectangle($destimg, 0, 0, $nWidth, $nHeight, $transparent);
		}

		imagecopyresampled($destimg, $srcimg, 0,0,0,0, $des_w, $des_h, $src_w, $src_h) or die("Problem In resizing"); 

		
		//Constructs dir if not exists. 
		if (!is_dir($destinationPath)){ 
			@mkdir($destinationPath); 
		} 
		@chmod($destinationPath, 0777); 
		
		// if destination name is set up
		if ($destinationName) $imageName = $destinationName;

		//Change name extension to jpg		
		//$imageName = change_ext($imageName, "jpg");
	
		if ($type =="jpeg" || $type =="jpg") { 
			imagejpeg($destimg, $destinationPath.$imageName, 90) or die("Problem In saving Image 8333");
		} elseif ($type =="gif") {
			imagegif($destimg, $destinationPath.$imageName) or die("Problem In saving Image 8334");
		} elseif ($type =="png") {
			imagepng($destimg, $destinationPath.$imageName) or die("Problem In saving Image 8335");
		} elseif ($type =="bmp") {
			$imageName = change_ext($imageName, "jpg");
			imagejpeg($destimg, $destinationPath.$imageName, 90) or die("Problem In saving Image 8336");
		}
		
		@chmod($destinationPath, 0755); 
	} 
} 



//$bmpimg = ImageCreateFromBMP('test.bmp');
//imagejpeg($bmpimg,'bmp2jpg.jpg');

// ¥H¤U¬O ImageCreateFromBMP ªº function

/*********************************************/
/* Fonction: ImageCreateFromBMP              */
/* Author:  DHKold                          */
/* Contact:  [email]admin@dhkold.com[/email]                */
/* Date:    The 15th of June 2005          */
/* Version:  2.0B                            */
/*********************************************/

function ImageCreateFromBMP($filename) {
//Ouverture du fichier en mode binaire
   if (! $f1 = fopen($filename,"rb")) return FALSE;

//1 : Chargement des ent?s FICHIER
   $FILE = unpack("vfile_type/Vfile_size/Vreserved/Vbitmap_offset", fread($f1,14));
   if ($FILE['file_type'] != 19778) return FALSE;

//2 : Chargement des ent?s BMP
   $BMP = unpack('Vheader_size/Vwidth/Vheight/vplanes/vbits_per_pixel'.
                 '/Vcompression/Vsize_bitmap/Vhoriz_resolution'.
                 '/Vvert_resolution/Vcolors_used/Vcolors_important', fread($f1,40));
   $BMP['colors'] = pow(2,$BMP['bits_per_pixel']);
   if ($BMP['size_bitmap'] == 0) $BMP['size_bitmap'] = $FILE['file_size'] - $FILE['bitmap_offset'];
   $BMP['bytes_per_pixel'] = $BMP['bits_per_pixel']/8;
   $BMP['bytes_per_pixel2'] = ceil($BMP['bytes_per_pixel']);
   $BMP['decal'] = ($BMP['width']*$BMP['bytes_per_pixel']/4);
   $BMP['decal'] -= floor($BMP['width']*$BMP['bytes_per_pixel']/4);
   $BMP['decal'] = 4-(4*$BMP['decal']);
   if ($BMP['decal'] == 4) $BMP['decal'] = 0;

//3 : Chargement des couleurs de la palette
   $PALETTE = array();
   if ($BMP['colors'] < 16777216)
   {
   $PALETTE = unpack('V'.$BMP['colors'], fread($f1,$BMP['colors']*4));
   }

//4 : Crù¯ion de l'image
   $IMG = fread($f1,$BMP['size_bitmap']);
   $VIDE = chr(0);

   $res = imagecreatetruecolor($BMP['width'],$BMP['height']);
   $P = 0;
   $Y = $BMP['height']-1;
   while ($Y >= 0)
   {
   $X=0;
   while ($X < $BMP['width'])
   {
     if ($BMP['bits_per_pixel'] == 24)
       $COLOR = unpack("V",substr($IMG,$P,3).$VIDE);
     elseif ($BMP['bits_per_pixel'] == 16)
     {  
       $COLOR = unpack("n",substr($IMG,$P,2));
       $COLOR[1] = $PALETTE[$COLOR[1]+1];
     }
     elseif ($BMP['bits_per_pixel'] == 8)
     {  
       $COLOR = unpack("n",$VIDE.substr($IMG,$P,1));
       $COLOR[1] = $PALETTE[$COLOR[1]+1];
     }
     elseif ($BMP['bits_per_pixel'] == 4)
     {
       $COLOR = unpack("n",$VIDE.substr($IMG,floor($P),1));
       if (($P*2)%2 == 0) $COLOR[1] = ($COLOR[1] >> 4) ; else $COLOR[1] = ($COLOR[1] & 0x0F);
       $COLOR[1] = $PALETTE[$COLOR[1]+1];
     }
     elseif ($BMP['bits_per_pixel'] == 1)
     {
       $COLOR = unpack("n",$VIDE.substr($IMG,floor($P),1));
       if    (($P*8)%8 == 0) $COLOR[1] =  $COLOR[1]        >>7;
       elseif (($P*8)%8 == 1) $COLOR[1] = ($COLOR[1] & 0x40)>>6;
       elseif (($P*8)%8 == 2) $COLOR[1] = ($COLOR[1] & 0x20)>>5;
       elseif (($P*8)%8 == 3) $COLOR[1] = ($COLOR[1] & 0x10)>>4;
       elseif (($P*8)%8 == 4) $COLOR[1] = ($COLOR[1] & 0x8)>>3;
       elseif (($P*8)%8 == 5) $COLOR[1] = ($COLOR[1] & 0x4)>>2;
       elseif (($P*8)%8 == 6) $COLOR[1] = ($COLOR[1] & 0x2)>>1;
       elseif (($P*8)%8 == 7) $COLOR[1] = ($COLOR[1] & 0x1);
       $COLOR[1] = $PALETTE[$COLOR[1]+1];
     }
     else
       return FALSE;
     imagesetpixel($res,$X,$Y,$COLOR[1]);
     $X++;
     $P += $BMP['bytes_per_pixel'];
   }
   $Y--;
   $P+=$BMP['decal'];
   }

//Fermeture du fichier
   fclose($f1);

return $res;
}

?>