<?
/*

- getClientesTiposElegir

- getProvincias					listado de provincias (arg)
- getLocalidades				listado de localidades - segun id_provincia


*/


/* clever-autodoc
<clever-autodoc>
	<file name="tbl_srv.php">
		<name>tbl_srv.php</name>
		<last_update>25/02/2019 15:10Hs</last_update>
		<updates>
			<item>
				<date>25/02/2019 15:10Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getClientesTiposElegir</name>
				<description>Llama al Stored Procedure: CP_Clientes_Tipos_Users_Visualizar para retornar el Browse de Clientes Tipos(Categorias) según lo que puede visualizar el usuario</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/* clever-autodoc
<clever-autodoc>
	<function name="getClientesTiposElegir">
		<name>getClientesTiposElegir</name>
		<description>Llama al Stored Procedure: CP_Clientes_Tipos_Users_Visualizar para retornar el Browse de Clientes Tipos(Categorias) según lo que puede visualizar el usuario</description>
		<parameters>
			<item>
				<name>pId_Usuario</name>
				<type>SMALLINT</type>
				<description>Id_Usuario del Sistema CleverSoft (Seg_Users). Del cual se quieren consultar los permisos de visualizaci{on de categorias.</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Tipo_Cli</name>
					<type>SMALLINT</type>
					<description>Codigo de la categoria</description>
				</item>
				<item>
					<name>Descripcion</name>
					<type>VARCHAR(50)</type>
					<description>Descripcion de la categoria</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getClientesTiposElegir INCIO*/
if ($_POST["getClientesTiposElegir"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getClientesTiposElegir: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Usuario = $data["pId_Usuario"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Usuario){
		
		$sql = "EXEC CP_Clientes_Tipos_Users_Visualizar ?";
		$params = array($pId_Usuario);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	  	//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getClientesTiposElegir: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getClientesTiposElegir: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getClientesTiposElegir: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getClientesTiposElegir FIN*/













?>