<?

/*
<clever-autodoc>
	<file name="sca.php">
		<name>sca.php</name>
		<last_update>05/02/2020 11:58Hs</last_update>
		<updates>
			<item>
				<date>05/02/2020 11:58Hs</date>
				<description>Se modificó el método: CP_SCA_RegistrarAcceso y CP_SCA_RegistrarAcceso_SinGrabado para recibir el parametro Flag_Permite_Paso para el permiso manual</description>
			</item>
			<item>
				<date>05/02/2020 11:45Hs</date>
				<description>Se modificó el método: CP_Clientes_Visitas para recibir el parametro Flag_Permite_Paso para el permiso manual</description>
			</item>
			<item>
				<date>30/01/2020 16:57Hs</date>
				<description>Se creó el método: CP_CD_ES_Rpt_Global_Ult_Accesos para devolver los ultimos accesos registrados en toda la base de datos</description>
			</item>
			<item>
				<date>05/12/2019 09:45Hs</date>
				<description>Se creó el método: CP_SCA_CD_ES_ABM para crear/modificar/borrar registros de la tabla CD_ES Manualmente</description>
			</item>
			<item>
				<date>29/10/2019 10:45Hs</date>
				<description>Se modificó el método: CP_Clientes_Visitas para recibir el parametro grabar en el campo Foto cuando se graba una foto</description>
			</item>
			<item>
				<date>23/10/2019 17:45Hs</date>
				<description>Se modificó el método: CP_Clientes_Visitas para recibir el parametro pFoto</description>
			</item>
			<item>
				<date>09/10/2019 11:55Hs</date>
				<description>Se modificó el método: CP_Clientes_Visitas para recibir los parametros pFlag_GrabaRegistro y pCredencial_Nro</description>
			</item>
			<item>
				<date>07/10/2019 12:39Hs</date>
				<description>Se agregó el método: CP_SCA_Clientes_Ult_Accesos</description>
			</item>
			<item>
				<date>25/09/2019 17:39Hs</date>
				<description>Se agregó el método: CP_SCA_Clientes_Huellas</description>
			</item>
			<item>
				<date>25/09/2019 12:37Hs</date>
				<description>Se agregó el método: CP_SCA_DescargarNovedades</description>
			</item>
			<item>
				<date>23/09/2019 16:18Hs</date>
				<description>Se agregó el método: CP_SCA_RegistrarAcceso_SinGrabado</description>
			</item>
			<item>
				<date>14/06/2019 12:08Hs</date>
				<description>Se agregó el método: getCDMotivosHabilitacionElegir</description>
			</item>		
			<item>
				<date>19/03/2019 11:52Hs</date>
				<description>Se modifico CP_CD_ES_Rpt_Anual_Ingresos para aceptar el parametro: pId_Accesos</description>
			</item>
			<item>
				<date>12/03/2019 17:04Hs</date>
				<description>Se agregó el método CP_CD_ES_Rpt_Anual_Ingresos</description>
			</item>
			<item>
				<date>22/02/2019 11:49Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>CF_SCA_IdControlador</name>
				<description>Llama a la función: CF_SCA_IdControlador para devolver el Id_Controlador que esta grabado en la tabla CD_Controladores</description>
			</item>
			<item>
				<name>CP_SCA_RegistrarAcceso</name>
				<description>Llama al Stored Procedure: CP_SCA_RegistrarAcceso validar el acceso y registrar el acceso en la tabla CD_ES</description>
			</item>
			<item>
				<name>CP_SCA_RegistrarAcceso_SinGrabado</name>
				<description>Llama al Stored Procedure: CP_SCA_RegistrarAcceso validar el acceso pero sin registrar el acceso en la tabla CD_ES</description>
			</item>
			<item>
				<name>CF_SCA_Cliente_ApeNom</name>
				<description>Llama a la función: CF_SCA_Cliente_ApeNom para devolver el Nombre y Apellido del Cliente</description>
			</item>
			<item>
				<name>CP_Clientes_Visitas</name>
				<description>Llama al Stored Procedure: CP_Clientes_Visitas que registra una visita en el SCA Visitor Web</description>
			</item>
			<item>
				<name>getBrowseCdEsLog</name>
				<description>Llama al Stored Procedure: CP_Browse_CD_ES_Log para retornar el Browse de Registros de Control de Acceso (CD_ES)</description>
			</item>
			<item>
				<name>getBrowse_SCA_Clientes_Elegir</name>
				<description>Llama al Stored Procedure: CP_Browse_SCA_Clientes_Elegir para retornar el Browse de Clientes filtrados</description>
			</item>
			<item>
				<name>CP_SCA_RegistrarLog</name>
				<description>Llama al Stored Procedure: CP_SCA_RegistrarLog para grabar un log en la tabla CD_Log</description>
			</item>
			<item>
				<name>CF_SCA_IdentifIdCliente</name>
				<description>Llama a la función: CF_SCA_IdentifIdCliente para devolver el Id_Cliente a partir de una cadena de datos (Ej. DNI Escaneado, Nro Socio, Nro DNI)</description>
			</item>
			<item>
				<name>CF_SCA_DatosAdicionales</name>
				<description>Llama a la función: CF_SCA_DatosAdicionales para devolver los datos adicionales del Cliente</description>
			</item>
			<item>
				<name>CP_CD_ES_Rpt_Anual_Ingresos</name>
				<description>Llama al stored: CP_CD_ES_Rpt_Anual_Ingresos para devolver el reporte anual por semana de Ingresos</description>
			</item>
			<item>
				<name>getCDMotivosHabilitacionElegir</name>
				<description>Llama al Stored Procedure: CP_CD_Motivos_Habilitacion_Elegir para retornar el Browse de Motivos de Habilitacion activos</description>
			</item>
			<item>
				<name>CP_SCA_DescargarNovedades</name>
				<description>Llama al Stored Procedure: CP_SCA_DescargarNovedades para retornar las Novedades de las listas Blancas</description>
			</item>
			<item>
				<name>CP_SCA_Clientes_Huellas</name>
				<description>Llama al Stored Procedure: CP_SCA_Clientes_Huellas para las Huellas de un Cliente</description>
			</item>
			<item>
				<name>CP_SCA_Clientes_Ult_Accesos</name>
				<description>Llama al Stored Procedure: CP_SCA_Clientes_Ult_Accesos para retornar los ultimos accesos de un Cliente</description>
			</item>
			<item>
				<name>CP_CD_ES_Rpt_Global_Ult_Accesos</name>
				<description>Llama al Stored Procedure: CP_CD_ES_Rpt_Global_Ult_Accesos para retornar los ultimos ultimos accesos registrados en toda la base de datos</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/*
<clever-autodoc>
	<function name="CF_SCA_IdControlador">
		<name>CF_SCA_IdControlador</name>
		<description>Llama a la función: CF_SCA_IdControlador para devolver el Id_Controlador que esta grabado en la tabla CD_Controladores</description>
		<parameters>
			<item>
				<name>pNroSerie</name>
				<type>VARCHAR</type>
				<description>Nro de Serie del Controlador. Ej. MAC</description>
			</item>
			<item>
				<name>pIPServidor</name>
				<type>VARCHAR</type>
				<description>IP Local del Servidor que controla el controlador</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Controlador</name>
					<type>INT</type>
					<description>Id_Controlador correspondiente</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_SCA_IdControlador INICIO*/
if ($_POST["CF_SCA_IdControlador"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_SCA_IdControlador: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pNroSerie = $data["pNroSerie"];
	$pIPServidor = $data["pIPServidor"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pNroSerie && $pIPServidor){
		
		$sql = "SELECT dbo.CF_SCA_IdControlador(?, ?) AS Id_Controlador";
		$params = array($pNroSerie, $pIPServidor);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_SCA_IdControlador: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_SCA_IdControlador: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$id_controlador = $row["Id_Controlador"];
			
	  		$res = array("data" => array("Id_Controlador" => $id_controlador), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
	  		
	  	}		
	}else{
		logError("CF_SCA_IdControlador: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_SCA_IdControlador FIN*/




/*
<clever-autodoc>
	<function name="CP_SCA_RegistrarAcceso">
		<name>CP_SCA_RegistrarAcceso</name>
		<description>Llama al Stored Procedure: CP_SCA_RegistrarAcceso validar el acceso y registrar el acceso en la tabla CD_ES</description>
		<parameters>
			<item>
				<name>pId_Controlador</name>
				<type>INT</type>
				<description>Id_Controlador que registra</description>
			</item>
			<item>
				<name>pTipoAcceso</name>
				<type>CHAR</type>
				<description>Tipo de Acceso E: Entrada, S: Salida</description>
			</item>
			<item>
				<name>pFecha</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha del registro</description>
			</item>
			<item>
				<name>pFechaEvento</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha del Evento</description>
			</item>
			<item>
				<name>pTag</name>
				<type>VARCHAR(MAX)</type>
				<description>Credencial_Nro</description>
			</item>
			<item>
				<name>pDoc</name>
				<type>BIGINT</type>
				<description>Nro. Documento</description>
			</item>
			<item>
				<name>pHue</name>
				<type>VARCHAR(5000)</type>
				<description>Huella</description>
			</item>
			<item>
				<name>pCba</name>
				<type>VARCHAR(20)</type>
				<description>Codigo de Barra</description>
			</item>
			<item>
				<name>pDma</name>
				<type>VARCHAR(5000)</type>
				<description>Data Matrix</description>
			</item>
			<item>
				<name>pFlag_Permite_Paso</name>
				<type>TINYINT</type>
				<description>Permite el proximo un proximo paso por un acceso</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Habilitado</name>
					<type>TINYINT</type>
					<description>0: Acceso Inhabilitado. 1: Acceso Habilitado</description>
				</item>
				<item>
					<name>Mensaje</name>
					<type>VARCHAR(5000)</type>
					<description>Motivo de habilitacion</description>
				</item>
				<item>
					<name>Info</name>
					<type>VARCHAR(101)</type>
					<description>Posibles valores: ERROR, ADVER, OBSER</description>
				</item>
				<item>
					<name>Foto</name>
					<type>VARCHAR(256)</type>
					<description>Path del archivo de foto en el servidor</description>
				</item>
				<item>
					<name>Foto_Bin</name>
					<type>IMAGE</type>
					<description>Imagen formato IMAGE</description>
				</item>
				<item>
					<name>Id_Cliente</name>
					<type>INT</type>
					<description>Id_Cliente de persona identificada</description>
				</item>
				<item>
					<name>Id_Cliente_Ref</name>
					<type>INT</type>
					<description>Id_Cliente del Titular del Grupo Familiar del Id_Cliente identificado</description>
				</item>
				<item>
					<name>Tiempo_Mensaje</name>
					<type>SMALLINT</type>
					<description>Tiempo en segundos a mostrar el mensaje en pantalla o display</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_RegistrarAcceso INICIO*/
if ($_POST["CP_SCA_RegistrarAcceso"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_RegistrarAcceso: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Controlador = $data["pId_Controlador"];
	$pTipoAcceso = $data["pTipoAcceso"];
	$pFecha = $data["pFecha"];
	$pFechaEvento = $data["pFechaEvento"];
	$pTag = $data["pTag"];
	$pDoc = $data["pDoc"];
	$pHue = $data["pHue"];
	$pCba = $data["pCba"];
	$pDma = $data["pDma"];
	$pFlag_Permite_Paso = (int)$data["pFlag_Permite_Paso"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Controlador && $pTipoAcceso){
		
		$sql = "EXEC CP_SCA_RegistrarAcceso ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, ?";
		$params = array($pId_Controlador, $pTipoAcceso, $pFecha, $pFechaEvento, $pTag, $pDoc, $pHue, $pCba, $pDma, $pFlag_Permite_Paso);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_RegistrarAcceso: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_RegistrarAcceso: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CP_SCA_RegistrarAcceso: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_RegistrarAcceso FIN*/


/*
<clever-autodoc>
	<function name="CP_SCA_RegistrarAcceso_SinGrabado">
		<name>CP_SCA_RegistrarAcceso_SinGrabado</name>
		<description>Llama al Stored Procedure: CP_SCA_RegistrarAcceso validar el acceso pero SIN registrar el acceso en la tabla CD_ES</description>
		<parameters>
			<item>
				<name>pId_Controlador</name>
				<type>INT</type>
				<description>Id_Controlador que registra</description>
			</item>
			<item>
				<name>pTipoAcceso</name>
				<type>CHAR</type>
				<description>Tipo de Acceso E: Entrada, S: Salida</description>
			</item>
			<item>
				<name>pFecha</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha del registro</description>
			</item>
			<item>
				<name>pFechaEvento</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha del Evento</description>
			</item>
			<item>
				<name>pTag</name>
				<type>VARCHAR(MAX)</type>
				<description>Credencial_Nro</description>
			</item>
			<item>
				<name>pDoc</name>
				<type>BIGINT</type>
				<description>Nro. Documento</description>
			</item>
			<item>
				<name>pHue</name>
				<type>VARCHAR(5000)</type>
				<description>Huella</description>
			</item>
			<item>
				<name>pCba</name>
				<type>VARCHAR(20)</type>
				<description>Codigo de Barra</description>
			</item>
			<item>
				<name>pDma</name>
				<type>VARCHAR(5000)</type>
				<description>Data Matrix</description>
			</item>
			<item>
				<name>pFlag_Permite_Paso</name>
				<type>TINYINT</type>
				<description>Permite el proximo un proximo paso por un acceso</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Habilitado</name>
					<type>TINYINT</type>
					<description>0: Acceso Inhabilitado. 1: Acceso Habilitado</description>
				</item>
				<item>
					<name>Mensaje</name>
					<type>VARCHAR(5000)</type>
					<description>Motivo de habilitacion</description>
				</item>
				<item>
					<name>Info</name>
					<type>VARCHAR(101)</type>
					<description>Posibles valores: ERROR, ADVER, OBSER</description>
				</item>
				<item>
					<name>Foto</name>
					<type>VARCHAR(256)</type>
					<description>Path del archivo de foto en el servidor</description>
				</item>
				<item>
					<name>Foto_Bin</name>
					<type>IMAGE</type>
					<description>Imagen formato IMAGE</description>
				</item>
				<item>
					<name>Id_Cliente</name>
					<type>INT</type>
					<description>Id_Cliente de persona identificada</description>
				</item>
				<item>
					<name>Id_Cliente_Ref</name>
					<type>INT</type>
					<description>Id_Cliente del Titular del Grupo Familiar del Id_Cliente identificado</description>
				</item>
				<item>
					<name>Tiempo_Mensaje</name>
					<type>SMALLINT</type>
					<description>Tiempo en segundos a mostrar el mensaje en pantalla o display</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_RegistrarAcceso_SinGrabado INICIO*/
if ($_POST["CP_SCA_RegistrarAcceso_SinGrabado"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_RegistrarAcceso_SinGrabado: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Controlador = $data["pId_Controlador"];
	$pTipoAcceso = $data["pTipoAcceso"];
	$pFecha = $data["pFecha"];
	$pFechaEvento = $data["pFechaEvento"];
	$pTag = $data["pTag"];
	$pDoc = $data["pDoc"];
	$pHue = $data["pHue"];
	$pCba = $data["pCba"];
	$pDma = $data["pDma"];
	$pFlag_Permite_Paso = (int)$data["pFlag_Permite_Paso"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Controlador && $pTipoAcceso){
		
		//Llama al mismo Stored CP_SCA_RegistrarAcceso pero con el ultimo parametro en 0
		$sql = "EXEC CP_SCA_RegistrarAcceso ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, ?";
		$params = array($pId_Controlador, $pTipoAcceso, $pFecha, $pFechaEvento, $pTag, $pDoc, $pHue, $pCba, $pDma, $pFlag_Permite_Paso);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_RegistrarAcceso_SinGrabado: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_RegistrarAcceso_SinGrabado: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CP_SCA_RegistrarAcceso_SinGrabado: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_RegistrarAcceso_SinGrabado FIN*/


/*
<clever-autodoc>
	<function name="CF_SCA_Cliente_ApeNom">
		<name>CF_SCA_Cliente_ApeNom</name>
		<description>Llama a la función: CF_SCA_Cliente_ApeNom para devolver el Nombre y Apellido del Cliente</description>
		<parameters>
			<item>
				<name>pId_cliente</name>
				<type>INT</type>
				<description>Id_Cliente que se desea recuperar el nombre y apellido</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ApeNom</name>
					<type>VARCHAR(100)</type>
					<description>Apellido y nombre del Cliente</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_SCA_Cliente_ApeNom INICIO*/
if ($_POST["CF_SCA_Cliente_ApeNom"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_SCA_Cliente_ApeNom: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_cliente"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente){
		
		$sql = "SELECT dbo.CF_SCA_Cliente_ApeNom(?) AS ApeNom";
		$params = array($pId_Cliente);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_SCA_Cliente_ApeNom: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_SCA_Cliente_ApeNom: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$apeNom = $row["ApeNom"];
			
	  		$res = array("data" => array("ApeNom" => $apeNom), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CF_SCA_Cliente_ApeNom: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_SCA_Cliente_ApeNom FIN*/



/*
<clever-autodoc>
	<function name="CP_Clientes_Visitas">
		<name>CP_Clientes_Visitas</name>
		<description>Llama al Stored Procedure: CP_Clientes_Visitas que registra una visita en el SCA Visitor Web.</description>
		<parameters>
			<item>
				<name>pApellido</name>
				<type>VARCHAR(100)</type>
				<description>Apellido del Socio</description>
			</item>
			<item>
				<name>pNombre</name>
				<type>VARCHAR(100)</type>
				<description>Nombre del Socio</description>
			</item>
			<item>
				<name>pDoc_Nro</name>
				<type>BIGINT</type>
				<description>Nro. Documento del Socio</description>
			</item>
			<item>
				<name>pSexo</name>
				<type>CHAR(1)</type>
				<description>Sexo del Socio</description>
			</item>
			<item>
				<name>pFecha_Nac</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha Nacimiento del Socio</description>
			</item>
			<item>
				<name>pId_Tipo_Cli</name>
				<type>SMALLINT</type>
				<description>Id_Tipo_Cli(Categoria) del Socio</description>
			</item>
			<item>
				<name>pMotivoIngreso</name>
				<type>VARCHAR(5000)</type>
				<description>Descripcion por la cual ingreso el socio</description>
			</item>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente si ya esta encontrado, sino 0</description>
			</item>
			<item>
				<name>pId_Controlador</name>
				<type>INT</type>
				<description>Id_Controlador con el cual registrará el acceso</description>
			</item>
			<item>
				<name>pFlag_GrabaRegistro</name>
				<type>TINYINT</type>
				<description>0: No graba el registro en CD_ES. 1: Graba el registro en CD_ES</description>
			</item>
			<item>
				<name>pCredencial_Nro</name>
				<type>VARCHAR(30)</type>
				<description>Nro Credencial a grabar en el Cliente</description>
			</item>
			<item>
				<name>pFoto</name>
				<type>VARCHAR(MAX)</type>
				<description>Foto del Cliente</description>
			</item>
			<item>
				<name>pFlag_Permite_Paso</name>
				<type>TINYINT</type>
				<description>Indica si debe permitir el proximo paso por un acceso</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description>Numero de Error de SQL (0: Sin error)</description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description>Tipo de gravadad del Error SQL (0: Sin error)</description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description>Estado del Error SQL (0: Sin error)</description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description>Error en Stored Procedure (0: Sin error)</description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description>Numero de linea en la cual se encuentra el error</description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>VARCHAR(200)</type>
					<description>Descripcion del error</description>
				</item>
				<item>
					<name>Id_Cliente</name>
					<type>INT</type>
					<description>Id_Cliente de la visita dada de alta</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Clientes_Visitas INICIO*/
if ($_POST["CP_Clientes_Visitas"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Clientes_Visitas: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
		
	$pApellido 			= mb_strtoupper($data["pApellido"]);
	$pNombre 			= mb_strtoupper($data["pNombre"]);
	$pDoc_Nro 			= $data["pDoc_Nro"];
	$pSexo 				= $data["pSexo"];
	$pFecha_Nac 		= $data["pFecha_Nac"];
	$pId_Tipo_Cli 		= $data["pId_Tipo_Cli"];
	$pMotivoIngreso 	= mb_strtoupper($data["pMotivoIngreso"]);
	$pId_Usuario_Alta	= $data["pId_Usuario_Alta"];
	$pId_Cliente		= (int)$data["pId_Cliente"];
	$pId_Controlador	= (int)$data["pId_Controlador"];
	$pFlag_GrabaRegistro= (int)$data["pFlag_GrabaRegistro"];
	$pCredencial_Nro	= $data["pCredencial_Nro"];
	$pFoto				= $data["pFoto"];
	$pFlag_Permite_Paso	= (int)$data["pFlag_Permite_Paso"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if (($pId_Cliente > 0 && $pMotivoIngreso) || ($pApellido && $pNombre && $pDoc_Nro && $pFecha_Nac && $pId_Tipo_Cli && $pMotivoIngreso && $pId_Usuario_Alta)){
		
		$sql = "EXEC CP_Clientes_Visitas ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pApellido, $pNombre, $pDoc_Nro, $pSexo, $pFecha_Nac, $pId_Tipo_Cli, $pMotivoIngreso, $pId_Usuario_Alta, $pId_Cliente, $pId_Controlador, $pFlag_GrabaRegistro, $pCredencial_Nro, $pFlag_Permite_Paso);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Clientes_Visitas: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Clientes_Visitas: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;				
				}
			}
			
			if(strcmp($pFoto, "") !== 0)
			{
				//Borra si tiene una foto actual
				$sql = "DELETE FROM Clientes_Fotos WHERE Id_Cliente = ".$res[0]["Id_Cliente"];
				
				$params = array();
							
				$stmt = sqlsrv_prepare($conn, $sql, $params);
				$stmt = sqlsrv_execute($stmt);
				
				//Verifica si hay algun error al ejecutar la consulta
				if( $stmt === false ) {
					//Verifica si se trata de un error de SQL
					if(($errors = sqlsrv_errors()) != null){
						logError("CP_Clientes_Visitas: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
						$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
						echo json_encode($res);
						exit;
					}else{
						logError("CP_Clientes_Visitas: Error sin descripcion", __LINE__);
						$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
						echo json_encode($res);
						exit;
					}
				}
				//FIN Verifica si hay algun error al ejecutar la consulta
				
				//Inserta la foto
				//Graba Clientes_Fotos
				$cliente_devuelto = $res[0]["Id_Cliente"];
				$sql = "INSERT INTO Clientes_Fotos (Id_Cliente, Nro, Fecha, Foto) VALUES (".$cliente_devuelto.", 1, GETDATE(), 0x". $pFoto.")";
				
				$params = array();
							
				$stmt = sqlsrv_prepare($conn, $sql, $params);
				$stmt = sqlsrv_execute($stmt);
				
				//Verifica si hay algun error al ejecutar la consulta
				if( $stmt === false ) {
					//Verifica si se trata de un error de SQL
					if(($errors = sqlsrv_errors()) != null){
						logError("CP_Clientes_Visitas: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
						$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
						echo json_encode($res);
						exit;
					}else{
						logError("CP_Clientes_Visitas: Error sin descripcion", __LINE__);
						$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
						echo json_encode($res);
						exit;
					}
				}
				//FIN Graba Clientes_Fotos
				
				//Actualiza Clientes campo Foto
				$sql = "UPDATE Clientes SET Foto = dbo.CF_xParam('Cli_Fotos_Dir_Loc') + '\' + CONVERT(VARCHAR(10), ". $cliente_devuelto .") + '.jpg' WHERE Id_Cliente = ".$cliente_devuelto;
				
				$params = array();
							
				$stmt = sqlsrv_prepare($conn, $sql, $params);
				$stmt = sqlsrv_execute($stmt);
				
				//Verifica si hay algun error al ejecutar la consulta
				if( $stmt === false ) {
					//Verifica si se trata de un error de SQL
					if(($errors = sqlsrv_errors()) != null){
						logError("CP_Clientes_Visitas: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
						$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
						echo json_encode($res);
						exit;
					}else{
						logError("CP_Clientes_Visitas: Error sin descripcion", __LINE__);
						$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
						echo json_encode($res);
						exit;
					}
				}
				//FIN Actualiza Clientes campo Foto
				//FIN Inserta la foto
			}
			
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CP_Clientes_Visitas: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Clientes_Visitas FIN*/



/*
<clever-autodoc>
	<function name="getBrowseCdEsLog">
		<name>getBrowseCdEsLog</name>
		<description>Llama al Stored Procedure: CP_Browse_CD_ES_Log para retornar el Browse de Registros de Control de Acceso (CD_ES)</description>
		<parameters>
			<item>
				<name>pFecha_Desde</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha Filtro Desde la que se quiere emitir el reporte(INCLUSIVE)</description>
			</item>
			<item>
				<name>pFecha_Hasta</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha Filtro Hasta la cual que se quiere emitir el reporte(INCLUSIVE)</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>			
				<item>
					<name>Codigo</name>
					<type>INT</type>
					<description>Codigo Id_ES, tabla CD_ES</description>
				</item>
				<item>
					<name>Tipo</name>
					<type>CHAR(1)</type>
					<description>I: Ingreso E:Egreso</description>
				</item>
				<item>
					<name>Origen</name>
					<type>CHAR(1)</type>
					<description>A: Automatico M:Manual</description>
				</item>
				<item>
					<name>Credencial</name>
					<type>VARCHAR(50)</type>
					<description>Nro. Credencial</description>
				</item>
				<item>
					<name>Pers_Cod</name>
					<type>INT</type>
					<description>Id_Cliente de la persona</description>
				</item>
				<item>
					<name>Pers_Nombre</name>
					<type>VARCHAR(100)</type>
					<description>Apellido y Nombre</description>
				</item>
				<item>
					<name>Pers_Categ</name>
					<type>VARCHAR(50)</type>
					<description>Categoria de la persona</description>
				</item>
				<item>
					<name>Fecha</name>
					<type>DATE</type>
					<description>Fecha del registro</description>
				</item>
				<item>
					<name>Hora</name>
					<type>VARCHAR(8)</type>
					<description>Hora del Registro</description>
				</item>
				<item>
					<name>Resultado</name>
					<type>CHAR(1)</type>
					<description>S: Satisfactorio. E: Erroneo</description>
				</item>
				<item>
					<name>Observacion</name>
					<type>VARCHAR(200)</type>
					<description>Descripcion del motivo de Ingreso o Rechazo</description>
				</item>
				<item>
					<name>Id_Acceso</name>
					<type>SMALLINT</type>
					<description>Codigo del Acceso(Puerta)</description>
				</item>
				<item>
					<name>Acceso</name>
					<type>VARCHAR(20)</type>
					<description>Descripcion Puerta</description>
				</item>
				<item>
					<name>Id_Controlador</name>
					<type>SMALLINT</type>
					<description>Codigo del Controlador</description>
				</item>
				<item>
					<name>Controlador</name>
					<type>VARCHAR(100)</type>
					<description>Descripcion del Controlador</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getBrowseCdEsLog INICIO*/
if ($_POST["getBrowseCdEsLog"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getBrowseCdEsLog: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pFecha_Desde = $data["pFecha_Desde"];
	$pFecha_Hasta = $data["pFecha_Hasta"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pFecha_Desde && $pFecha_Hasta){
		
		$sql = "EXEC CP_Browse_CD_ES_Log ?, ?";
		$params = array($pFecha_Desde, $pFecha_Hasta);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getBrowseCdEsLog: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getBrowseCdEsLog: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getBrowseCdEsLog: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getBrowseCdEsLog FIN*/



/*
<clever-autodoc>
	<function name="getBrowse_SCA_Clientes_Elegir">
		<name>getBrowse_SCA_Clientes_Elegir</name>
		<description>Llama al Stored Procedure: CP_Browse_SCA_Clientes_Elegir para retornar el Browse de Clientes filtrados</description>
		<parameters>		
			<item>
				<name>pTipo_Validacion</name>
				<type>CHAR(1)</type>
				<description>'T': Tag | 'D': Documento | 'H': Huella | 'B': Codigo Barras | 'M': Data Matrix | 'R': Razon_Social</description>
			</item>
			<item>
				<name>pTag</name>
				<type>VARCHAR(30)</type>
				<description>Credencial MiFare / Wiegand</description>
			</item>
			<item>
				<name>pDoc</name>
				<type>BIGINT</type>
				<description>Documento</description>
			</item>
			<item>
				<name>pHue</name>
				<type>VARCHAR(5000)</type>
				<description>Huella Dactilar</description>
			</item>
			<item>
				<name>pCba</name>
				<type>VARCHAR(20)</type>
				<description>Codigo de Barra</description>
			</item>
			<item>
				<name>pDma</name>
				<type>VARCHAR(5000)</type>
				<description>Data Matrix</description>
			</item>
			<item>
				<name>pRazon_Social</name>
				<type>VARCHAR(100)</type>
				<description>Apellido y Nombre del Cliente</description>
			</item>
			<item>
				<name>pId_Cliente_Externo</name>
				<type>VARCHAR(14)</type>
				<description>Nro. Socio del Cliente</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>						
				<item>
					<name>Codigo</name>
					<type>INT</type>
					<description>Id_Cliente del Socio</description>
				</item>
				<item>
					<name>Activo</name>
					<type>TINYINT</type>
					<description>1: Activo. 0: Inactivo</description>
				</item>
				<item>
					<name>Nro_Socio</name>
					<type>VARCHAR(14)</type>
					<description>Numero de Socio</description>
				</item>
				<item>
					<name>Apellido_Nombre</name>
					<type>VARCHAR(100)</type>
					<description>Apellido y Nombre del Socio</description>
				</item>
				<item>
					<name>Apellido</name>
					<type>VARCHAR(100)</type>
					<description>Apellido del Socio</description>
				</item>
				<item>
					<name>Nombre</name>
					<type>VARCHAR(100)</type>
					<description>Nombre del Socio</description>
				</item>
				<item>
					<name>Sexo</name>
					<type>CHAR(1)</type>
					<description>Sexo del Socio</description>
				</item>
				<item>
					<name>Id_Tipo_Cli</name>
					<type>SMALLINT</type>
					<description>Codigo de Categoria del Socio</description>
				</item>
				<item>
					<name>Categoria</name>
					<type>VARCHAR(50)</type>
					<description>Categoria del Socio</description>
				</item>
				<item>
					<name>Fecha_Nac</name>
					<type>DATETIME</type>
					<description>Fecha Nacimiento del Socio</description>
				</item>
				<item>
					<name>Tipo_Doc</name>
					<type>CHAR(3)</type>
					<description>Tipo de Documento del Socio</description>
				</item>
				<item>
					<name>Doc_Nro</name>
					<type>BIGINT</type>
					<description>Numero de Documento del Socio</description>
				</item>
				<item>
					<name>Ult_Cuota_Paga</name>
					<type>DATETIME</type>
					<description>Fecha de Ultima Cuota Paga del Socio</description>
				</item>
				<item>
					<name>Credencial_Nro</name>
					<type>VARCHAR(30)</type>
					<description>Numero de Credencial del Socio</description>
				</item>
				<item>
					<name>Legajo</name>
					<type>VARCHAR(30)</type>
					<description>Numero del Legajo del Socio</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getBrowse_SCA_Clientes_Elegir INICIO*/
if ($_POST["getBrowse_SCA_Clientes_Elegir"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getBrowse_SCA_Clientes_Elegir: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pTipo_Validacion 	= $data["pTipo_Validacion"];
	$pTag 				= $data["pTag"];
	$pDoc 				= $data["pDoc"];
	$pHue 				= $data["pHue"];
	$pCba 				= $data["pCba"];
	$pDma 				= $data["pDma"];
	$pRazon_Social 		= $data["pRazon_Social"];
	$pId_Cliente_Externo = $data["pId_Cliente_Externo"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pTipo_Validacion){
		
		$sql = "EXEC CP_Browse_SCA_Clientes_Elegir ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pTipo_Validacion, $pTag, $pDoc, $pHue, $pCba, $pDma, $pRazon_Social, $pId_Cliente_Externo);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getBrowse_SCA_Clientes_Elegir: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getBrowse_SCA_Clientes_Elegir: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{			
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getBrowse_SCA_Clientes_Elegir: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getBrowse_SCA_Clientes_Elegir FIN*/



/*
<clever-autodoc>
	<function name="CP_SCA_RegistrarLog">
		<name>CP_SCA_RegistrarLog</name>
		<description>Llama al Stored Procedure: CP_SCA_RegistrarLog para grabar un log en la tabla CD_Log</description>
		<parameters>
			<item>
				<name>pFecha</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha del Log</description>
			</item>
			<item>
				<name>pTipo</name>
				<type>CHAR(2)</type>
				<description>Tipo de Log (IN: Informacion / ER: Error)</description>
			</item>
			<item>
				<name>pDescripcion</name>
				<type>VARCHAR(1000)</type>
				<description>Descripcion del Log</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>MensajeRespuesta</name>
					<type>VARCHAR(100)</type>
					<description>Mensaje: Registro Guardado</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_RegistrarLog INICIO*/
if ($_POST["CP_SCA_RegistrarLog"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_RegistrarLog: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pFecha = $data["pFecha"];		
	$pTipo = $data["pTipo"];
	$pDescripcion = $data["pDescripcion"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pTipo && $pDescripcion){
		
		$sql = "EXEC CP_SCA_RegistrarLog ?, ?, ?";
		$params = array($pFecha, $pTipo, $pDescripcion);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_RegistrarLog: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_RegistrarLog: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CP_SCA_RegistrarLog: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_RegistrarLog FIN*/



/*
<clever-autodoc>
	<function name="CF_SCA_IdentifIdCliente">
		<name>CF_SCA_IdentifIdCliente</name>
		<description>Llama a la función: CF_SCA_IdentifIdCliente para devolver el Id_Cliente a partir de una cadena de datos (Ej. DNI Escaneado, Nro Socio, Nro DNI)</description>
		<parameters>
			<item>
				<name>pDato</name>
				<type>VARCHAR(100)</type>
				<description>Dato a buscar para identificar al Id_Cliente</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Cliente</name>
					<type>INT</type>
					<description>Id_Cliente identificado</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_SCA_IdentifIdCliente INICIO*/
if ($_POST["CF_SCA_IdentifIdCliente"]==1){


	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_SCA_IdentifIdCliente: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pDato = $data["pDato"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pDato != ""){
		
		$sql = "SELECT dbo.CF_SCA_IdentifIdCliente(?) AS Id_Cliente";
		$params = array($pDato);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_SCA_IdentifIdCliente: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_SCA_IdentifIdCliente: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$id_cliente = $row["Id_Cliente"];
			
	  		$res = array("data" => array("Id_Cliente" => $id_cliente), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CF_SCA_IdentifIdCliente: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_SCA_IdentifIdCliente FIN*/



/*
<clever-autodoc>
	<function name="CF_SCA_DatosAdicionales">
		<name>CF_SCA_DatosAdicionales</name>
		<description>Llama a la función: CF_SCA_DatosAdicionales para devolver los datos adicionales del Cliente</description>
		<parameters>
			<item>
				<name>pId_cliente</name>
				<type>VARCHAR(100)</type>
				<description>Id_Cliene a buscar</description>
			</item>
			<item>
				<name>pId_Evento</name>
				<type>VARCHAR(100)</type>
				<description>Id_Lista_Precio para Control de Eventos (Ej. IDEA)</description>
			</item>
			<item>
				<name>pFecha</name>
				<type>DATETIME(yyyy-MM-ddTHH:mm:ss)</type>
				<description>Fecha a Comparar</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>datosAdicionales</name>
					<type>VARCHAR(MAX)</type>
					<description>Datos Adicionales</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_SCA_DatosAdicionales INICIO*/
if ($_POST["CF_SCA_DatosAdicionales"]==1){
	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_SCA_DatosAdicionales: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_cliente"];
	$pId_Evento = $data["pId_Evento"];
	$pFecha = $data["pFecha"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente){
		
		$sql = "SELECT dbo.CF_SCA_DatosAdicionales(?, ?, ?) AS datosAdicionales";
		$params = array($pId_Cliente, $pId_Evento, $pFecha);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_SCA_DatosAdicionales: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_SCA_DatosAdicionales: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$datosAdicionales = $row["datosAdicionales"];
			
	  		$res = array("data" => array("datosAdicionales" => $datosAdicionales), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CF_SCA_DatosAdicionales: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_SCA_DatosAdicionales FIN*/


/*
<clever-autodoc>
	<function name="CP_CD_ES_Rpt_Anual_Ingresos">
		<name>CP_CD_ES_Rpt_Anual_Ingresos</name>
		<description>Llama al stored: CP_CD_ES_Rpt_Anual_Ingresos para devolver el reporte anual por semana de Ingresos</description>
		<parameters>
			<item>
				<name>pAnio</name>
				<type>SMALLINT</type>
				<description>Año del cual se quiere sacar el reporte</description>
			</item>
			<item>
				<name>pId_Accesos</name>
				<type>VARCHAR(MAX)</type>
				<description>Id_Accesos separados por coma de los cuales se quiere filtran (si no se desea filtrar nada poner '')</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Semanas</name>
					<type>VARCHAR(10)</type>
					<description>Nro de Semana del año</description>
				</item>
				<item>
					<name>Desde_Hasta</name>
					<type>VARCHAR(15)</type>
					<description>Fecha desde y hasta que comprende la semana</description>
				</item>
				<item>
					<name>Lunes</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Lunes</description>
				</item>
				<item>
					<name>Martes</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Martes</description>
				</item>
				<item>
					<name>Miercoles</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Miercoles</description>
				</item>
				<item>
					<name>Jueves</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Jueves</description>
				</item>
				<item>
					<name>Viernes</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Viernes</description>
				</item>
				<item>
					<name>Sabados</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Sabados</description>
				</item>
				<item>
					<name>Domingos</name>
					<type>INT</type>
					<description>Cantidad de Ingresos de los Domingos</description>
				</item>
				<item>
					<name>Total</name>
					<type>INT</type>
					<description>Cantidad de Ingresos Totales de la semana</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_CD_ES_Rpt_Anual_Ingresos INICIO*/
if ($_POST["CP_CD_ES_Rpt_Anual_Ingresos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_CD_ES_Rpt_Anual_Ingresos: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pAnio = $data["pAnio"];
	$pId_Accesos = $data["pId_Accesos"];
	$pId_Accesos = "'" . $pId_Accesos . "'";
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pAnio){
		
		$sql = "EXEC CP_CD_ES_Rpt_Anual_Ingresos ?, ?";
		$params = array($pAnio, $pId_Accesos);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_CD_ES_Rpt_Anual_Ingresos: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_CD_ES_Rpt_Anual_Ingresos: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_CD_ES_Rpt_Anual_Ingresos: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_CD_ES_Rpt_Anual_Ingresos FIN*/


/*
<clever-autodoc>
	<function name="getCDMotivosHabilitacionElegir">
		<name>getCDMotivosHabilitacionElegir</name>
		<description>Llama al Stored Procedure: CP_CD_Motivos_Habilitacion_Elegir para retornar el Browse de Motivos de Habilitacion activos</description>
		<parameters>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_CD_Motivo</name>
					<type>INT</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Descripcion</name>
					<type>VARCHAR(5000)</type>
					<description>Descripcion de la Motivo de Habilitacion</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getCDMotivosHabilitacionElegir INCIO*/
if ($_POST["getCDMotivosHabilitacionElegir"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getCDMotivosHabilitacionElegir: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

			
	$sql = "EXEC CP_CD_Motivos_Habilitacion_Elegir";
	//$params = array($pId_Usuario);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	
	//Verifica si hay algun error al ejecutar la consulta
	if( $stmt === false ) {
		//Verifica si se trata de un error de SQL
		if(($errors = sqlsrv_errors()) != null){
			logError("getCDMotivosHabilitacionElegir: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
			$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
			echo json_encode($res);
			exit;
		}else{
			logError("getCDMotivosHabilitacionElegir: Error sin descripcion", __LINE__);
			$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
			echo json_encode($res);
			exit;
		}
	}else{
		//Resultado consulta SQL OK
		while ( sqlsrv_next_result($stmt) ){
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$res[] = $row;
			}
		}
			
		$res = array("data" => $res, "status" => 200, "message" => "");
		echo json_encode($res);
		exit;
	}
}
/*getCDMotivosHabilitacionElegir FIN*/


/*
<clever-autodoc>
	<function name="CP_SCA_DescargarNovedades">
		<name>CP_SCA_DescargarNovedades</name>
		<description>Llama al Stored Procedure: CP_SCA_DescargarNovedades para retornar las Novedades de la lista blanca</description>
		<parameters>
			<item>
				<name>pListado_Id_Controladores</name>
				<type>VARCHAR(MAX)</type>
				<description>Listado de controladores que se quieren descargar novedades, separados con coma con una coma al final (Ej. 1,2,)</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Controlador</name>
					<type>INT</type>
					<description>Id_Controlador de la novedad</description>
				</item>
				<item>
					<name>Id_Novedad</name>
					<type>INT</type>
					<description>Codigo de la Novedad</description>
				</item>
				<item>
					<name>Credencial_Nro</name>
					<type>VARCHAR(30)</type>
					<description>Credencial que se analizará la novedad</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_DescargarNovedades INICIO*/
if ($_POST["CP_SCA_DescargarNovedades"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_DescargarNovedades: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pListado_Id_Controladores = $data["pListado_Id_Controladores"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pListado_Id_Controladores){
				
		$sql = "EXEC CP_SCA_DescargarNovedades ?";
		$params = array($pListado_Id_Controladores);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_DescargarNovedades: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_DescargarNovedades: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}		
	}else{
		logError("CP_SCA_DescargarNovedades: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_DescargarNovedades FIN*/


/*
<clever-autodoc>
	<function name="CP_SCA_Clientes_Huellas">
		<name>CP_SCA_Clientes_Huellas</name>
		<description>Llama al Stored Procedure: CP_SCA_Clientes_Huellas para retornar las Huellas de un Cliente</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente del cual se quiere retornar las huellas</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Controlador</name>
					<type>INT</type>
					<description>Id_Controlador de la novedad</description>
				</item>
				<item>
					<name>Id_Novedad</name>
					<type>INT</type>
					<description>Codigo de la Novedad</description>
				</item>
				<item>
					<name>Credencial_Nro</name>
					<type>VARCHAR(30)</type>
					<description>Credencial que se analizará la novedad</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_Clientes_Huellas INICIO*/
if ($_POST["CP_SCA_Clientes_Huellas"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_Clientes_Huellas: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_Cliente"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente > 0){
				
		$sql = "EXEC CP_SCA_Clientes_Huellas ?";
		$params = array($pId_Cliente);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_Clientes_Huellas: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_Clientes_Huellas: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;  		
	  	}		
	}else{
		logError("CP_SCA_Clientes_Huellas: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_Clientes_Huellas FIN*/


/*
<clever-autodoc>
	<function name="CP_SCA_Clientes_Ult_Accesos">
		<name>CP_SCA_Clientes_Ult_Accesos</name>
		<description>Llama al Stored Procedure: CP_SCA_Clientes_Ult_Accesos para retornar los ultimos accesos de un Cliente</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente del cual se quiere retornar los ultimos accesos</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Fecha</name>
					<type>VARCHAR</type>
					<description>Fecha del Acceso</description>
				</item>
				<item>
					<name>Hora</name>
					<type>VARCHAR</type>
					<description>Hora del Acceso</description>
				</item>
				<item>
					<name>Resultado</name>
					<type>VARCHAR</type>
					<description>Resultado del Acceso</description>
				</item>
				<item>
					<name>Motivo</name>
					<type>VARCHAR</type>
					<description>Motivo del resultado del Acceso</description>
				</item>
				<item>
					<name>Acceso</name>
					<type>VARCHAR</type>
					<description>Nombre del Acceso/Puerta</description>
				</item>
				<item>
					<name>Controlador</name>
					<type>VARCHAR</type>
					<description>Nombre del Controlador</description>
				</item>				
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_Clientes_Ult_Accesos INICIO*/
if ($_POST["CP_SCA_Clientes_Ult_Accesos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_Clientes_Ult_Accesos: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_Cliente"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente > 0){
				
		$sql = "EXEC CP_SCA_Clientes_Ult_Accesos ?";
		$params = array($pId_Cliente);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_Clientes_Ult_Accesos: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_Clientes_Ult_Accesos: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;  		
	  	}		
	}else{
		logError("CP_SCA_Clientes_Ult_Accesos: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_Clientes_Ult_Accesos FIN*/


/*
<clever-autodoc>
	<function name="CP_SCA_CD_ES_ABM">
		<name>CP_SCA_CD_ES_ABM</name>
		<description>Llama al Stored Procedure: CP_SCA_CD_ES_ABM para Agregar/Modificar/Borrar un registro de la tabla CD_ES</description>
		<parameters>
			<item>
				<name>pTipoMovimiento</name>
				<type>CHAR(1)</type>
				<description>A: Alta. M: Modificacion. B: Baja</description>
			</item>
			<item>
				<name>pId_ES</name>
				<type>INT</type>
				<description>Id_ES de la tabla CD_ES para operaciones Modificaciones/Borrar</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_ES</name>
					<type>INT</type>
					<description>Id_ES Agregado o Modificado o Borrado</description>
				</item>			
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_SCA_CD_ES_ABM INICIO*/
if ($_POST["CP_SCA_CD_ES_ABM"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_SCA_CD_ES_ABM: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pTipoMovimiento = $data["pTipoMovimiento"];
	$pId_ES = $data["pId_ES"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pTipoMovimiento){
				
		$sql = "EXEC CP_SCA_CD_ES_ABM ?";
		$params = array($pTipoMovimiento);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_SCA_CD_ES_ABM: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_SCA_CD_ES_ABM: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;  		
	  	}		
	}else{
		logError("CP_SCA_CD_ES_ABM: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_SCA_CD_ES_ABM FIN*/


/*
<clever-autodoc>
	<function name="CP_CD_ES_Rpt_Global_Ult_Accesos">
		<name>CP_CD_ES_Rpt_Global_Ult_Accesos</name>
		<description>Llama al Stored Procedure: CP_CD_ES_Rpt_Global_Ult_Accesos para traerlos ultimos un registros de la tabla CD_ES</description>
		<parameters>
			<item>
				<name>pCantUltRegistros</name>
				<type>INT</type>
				<description>Cantidad de ultimos registros a retornar</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_ES</name>
					<type>INT</type>
					<description>Id_ES Agregado o Modificado o Borrado</description>
				</item>			
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_CD_ES_Rpt_Global_Ult_Accesos INICIO*/
if ($_POST["CP_CD_ES_Rpt_Global_Ult_Accesos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_CD_ES_Rpt_Global_Ult_Accesos: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pCantUltRegistros = $data["pCantUltRegistros"];

	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pCantUltRegistros){
				
		$sql = "EXEC CP_CD_ES_Rpt_Global_Ult_Accesos ?";
		$params = array($pCantUltRegistros);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_CD_ES_Rpt_Global_Ult_Accesos: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_CD_ES_Rpt_Global_Ult_Accesos: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
	  		$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;  		
	  	}		
	}else{
		logError("CP_CD_ES_Rpt_Global_Ult_Accesos: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_CD_ES_Rpt_Global_Ult_Accesos FIN*/

?>