<?

/*

- register
- login
- cambioClave

- getUser						devuelve la info / para reempadronamiento

- updateUser					guarda toda la info a la tabla Clientes_Temp de los cambios que hizo el usuario (user.php)
- getTempUser					devuelve la info / para corregir los datos de inscripcion
- setTempUser					guarda toda la info a la tabla Clientes_Temp

- esSocioDni					Busca la existencia de un socio x DNI



*/





# ==================================================================================
# 
# Register
# register=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"nro_socio":"1","documento":"1","email":"1"}
# 
# ==================================================================================

if ($_POST["register"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_nro_socio = trim($data["nro_socio"]);
	$data_documento = trim($data["documento"]);
	$data_email = trim($data["email"]);
	
	 //print_r($data_nro_socio);
	 //exit();
	 
	 
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa los datos - proceso principal
	if ($data_nro_socio && $data_documento && $data_email){
	
		$sql = "SELECT
					Id_Cliente, Id_Cliente_Externo, Razon_Social Doc_Nro, Email_Web, Clave_Web
					FROM Clientes
					WHERE 
					Id_Cliente_Externo = $data_nro_socio
					and Doc_Nro = $data_documento
					and activo=1
				";
		$params = array($data_nro_socio, $data_documento);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  		$id_cliente = $row["Id_Cliente"];
	  		$nro_cliente = $row["Id_Cliente_Externo"];

	  		if (!$id_cliente){
	  			$resp = array("data" => $data, "status" => 401, "message" => "Error en datos");
		  		echo json_encode($resp);
		  		exit;
	  		}

			// Si no tiene clave la genero sino uso la misma
  			if ($row["Clave_Web"]==""){
  				$new_pass = rand(100000, 99999999);
  				$pss = "Clave_Web='" . $new_pass . "'";
  				$password = $new_pass;
  			}else{
  				$password = $row["Clave_Web"];  				
  			}
	  		
			// Si no tiene email lo agrego sino uso el mismo
  			if ($row["email"]==""){
  				if ($pss!="") $contact = ", ";
  				$emm = "Email_Web='" . $data_email . "'";
  				$send_email = $data_email;
  			}else{
  				$send_email = $row["email"];
  			}
  			if ($pss!="" || $emm!=""){
  				$sql = "UPDATE clientes SET $pss $contact $emm WHERE Id_Cliente='" . $id_cliente . "'";
				$params = array();
	    		$res = sqlsrv_query($conn, $sql);
  			}
  			
  			/*
  			if ($id_cliente){
  				$body  = "<strong>" . $nombre_cliente . "</strong><br>";
  				$body .= "<a href='" . $link_cliente . "'>" . $link_cliente . "</a><br><br>";
  				$body .= "Pedido de contraseÃ±a<br><br>";
  				$body .= "Número de Socio: " . $row["numero"] . "<br>";
  				$body .= "ContraseÃ±a: " . $password . "<br><br>";
  				$status = enviar_mail ($mail_cliente, $send_email, "", "$nombre_cliente - Pedido de contraseÃ±a", $body);	
  			}
  			*/
  			
  			$data = array("nro_socio" => $nro_cliente, "email" => $send_email, 'password' => $password );
	  		
	  		$resp = array("data" => $data, "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
	  		
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}








# ==================================================================================
# 
# Login
# login=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"email":"1", "password":"1"}
# 
# ==================================================================================

if ($_POST["login"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_email = trim($data["email"]);
	$data_password = trim($data["password"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_email && $data_password){
	
		
		if (strtoupper( substr($data_email,0,3) )=="ID:" && $data_password == "2456"){
			$sql = "select
						Id_Cliente, Id_Cliente_Ref, Apellido, Nombre, Razon_Social, Email_Web, Ult_Cuota_Paga, Id_Cliente_Externo, Id_Tipo_Cli
						from Clientes
						where
						id_Cliente = " .  substr($data_email,3,strlen($data_email) - 3 )  ."
						and activo=1
					";
		
		}
		else {
	
			$sql = "select
						Id_Cliente, Id_Cliente_Ref, Apellido, Nombre, Razon_Social, Email_Web, Ult_Cuota_Paga, Id_Cliente_Externo, Id_Tipo_Cli
						from Clientes
						where
						Email_Web = ?
						and Clave_Web = ?
						and activo=1
					";
		}		
		$params = array($data_email, $data_password);
		log_query($query, $params);
		$stmt = sqlsrv_query( $conn, $sql, $params, array("scrollable" => 'keyset'));
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
		
			$cant = sqlsrv_num_rows($stmt);			
			if ($cant==1){
			
		  		$cliente_login = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
		  		
		  		if ($cliente_login["Id_Cliente_Ref"]>0){	// Grupo 
		  			
		  			$sql = "SELECT
								Id_Cliente, Id_Cliente_Ref, Apellido, Nombre, Razon_Social, Email_Web, Ult_Cuota_Paga, Id_Cliente_Externo, Id_Tipo_Cli
								from Clientes
								where activo=1
									and (Id_Cliente=? or Id_Cliente_Ref=?)
									and Id_Cliente<>?
								";
		  			$params = array($cliente_login["Id_Cliente_Ref"], $cliente_login["Id_Cliente_Ref"], $cliente_login["Id_Cliente"]);
		  			$stmt = sqlsrv_query( $conn, $sql, $params);
					if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	logError("Error sql 8573987", __LINE__);
							$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
				  			echo json_encode($res);
				  			exit;
				  	    }
					}else{

						while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
							$grupo_familiar[] = $row;
						}

					}

		  		}
				
				
		  		$resp = array(
		  			"Id_Cliente" => (int)$cliente_login["Id_Cliente"],
		  			"Apellido" => trim($cliente_login["Apellido"]),
		  			"Nombre" => trim($cliente_login["Nombre"]),
		  			"Razon_Social" => trim($cliente_login["Razon_Social"]),
		  			"Email_Web" => trim($cliente_login["Email_Web"]),
		  			"Ult_Cuota_Paga" => trim($cliente_login["Ult_Cuota_Paga"]),
		  			"Id_Cliente_Externo" => trim($cliente_login["Id_Cliente_Externo"]),
		  			"Id_Tipo_Cli" => trim($cliente_login["Id_Tipo_Cli"]),
		  			"Id_Cliente_Ref" => trim($cliente_login["Id_Cliente_Ref"]),
		  			"grupo_familiar" => $grupo_familiar,
		  		);
		  		
		  		$resp = array("data" => $resp, "status" => 200, "message" => "");
		  		echo json_encode($resp);
		  		exit;
		  		
			}else{
			
	  	    	$res = array("data" => "", "status" => 401, "message" => "Error 8573988 " . __LINE__);
	  			echo json_encode($res);
	  			exit;
			
			}

		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}






# ==================================================================================
# 
# Funcion: cambioClave
# 
# ==================================================================================
# 
# data (POST)
# 	id_cliente, clave_anterior, clave_nueva
# 
# ==================================================================================
if ($_POST["cambioClave"]==1){
	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	// Parametros >
	$data_id_cliente = trim($data["id_cliente"]);
	$data_clave_anterior = trim($data["clave_anterior"]);
	$data_clave_nueva = trim($data["clave_nueva"]);
	// < Parametros
	
	// verifica si el json es valido
	if ($jsonerror){
		logError("Invalid JSON", __LINE__);
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	
	// verificar clave nueva.. mas de 3 caract..
	if (strlen($data_clave_nueva)<4){
		logError("clave nueva invalida", __LINE__);
		$res = array("data" => "", "status" => 500, "message" => "Clave nueva inválida.");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_clave_anterior && $data_clave_nueva){
	
		$sql = "select Id_Cliente, Clave_Web from Clientes
					where activo=1
					and Id_Cliente = ?
				";
		$params = array($data_id_cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  		if ($row){
	  			$clave_anterior_db = $row["Clave_Web"];
	  			if ($clave_anterior_db == $data_clave_anterior){

					$sql = "UPDATE Clientes set Clave_Web = ? WHERE Id_Cliente = ?";
					$params = array($data_clave_nueva, $data_id_cliente);
					$stmt = sqlsrv_query( $conn, $sql, $params);
					if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	logError("Error sql 657646", __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 657646");
				  			echo json_encode($res);
				  			exit;
				  	    }
					}else{
				  		$resp = array("data" => "", "status" => 200, "message" => "");
				  		echo json_encode($resp);
				  		exit;
					}

	  			}else{
		  	    	logError("Error clave anterior 5683476", __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error clave anterior 5683476");
		  			echo json_encode($res);
		  			exit;
	  			}
	  		}

		}

	}

	// final de codigo - error
	logError("Incorrect Data", __LINE__);
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}


















# ==================================================================================
# 
# Datos para reempadronamiento
# getUser=1
# 
# ==================================================================================
# 
# data (POST)
# 
# 	{"id_cliente":"1"}						busca por id
# 
#   {"xnumero":"1", "numero":"888"}			busca por numero de socio o documento
# 
# 
# ==================================================================================

if ($_POST["getUser"]==1){



	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = trim($data["id_cliente"]);
	$data_xnumero = trim($data["xnumero"]);
	$data_numero = trim($data["numero"]);
	
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_id_cliente || $data_numero){
	
		if ($data_id_cliente){
			$sql = "SELECT TOP 1 * FROM Clientes WHERE Id_Cliente=?";
			$params = array($data_id_cliente);
		} elseif ($data_xnumero && $data_numero){
			$sql = "SELECT TOP 1 * FROM Clientes WHERE Id_Cliente_Externo=? or (Doc_Nro=? and Doc_Nro>0)";
			$params = array($data_numero, (is_numeric($data_numero)?$data_numero:0) );
		}else{
			$res = array("data" => "", "status" => 400, "message" => "Error 84584 sin id o nro");
	  		echo json_encode($res);
	  		exit;
	  	}
		
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
  	    		logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
		
	  		$cliente = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  		$id_cliente = $cliente["Id_Cliente"];
	  		
	  		
	  		// xCampos Campos adicionales 180924 (VELEZ)
  			$sql = "SELECT
	  					x1.Valor_String as x_discapacitado,
	  					x2.Valor_String as x_tipodiscapacidad,
	  					x3.Valor_String as x_nrodecredencial,
	  					x4.Valor_String as x_obsdiscapacidad,
	  					x5.Valor_String as x_fechadevencimiento
  					FROM Clientes c
	  					LEFT JOIN Clientes_XCampos x1 on c.Id_Cliente=x1.Id_Cliente and x1.Id_Campo=2
	  					LEFT JOIN Clientes_XCampos x2 on c.Id_Cliente=x2.Id_Cliente and x2.Id_Campo=3
	  					LEFT JOIN Clientes_XCampos x3 on c.Id_Cliente=x3.Id_Cliente and x3.Id_Campo=4
	  					LEFT JOIN Clientes_XCampos x4 on c.Id_Cliente=x4.Id_Cliente and x4.Id_Campo=5
	  					LEFT JOIN Clientes_XCampos x5 on c.Id_Cliente=x5.Id_Cliente and x5.Id_Campo=6	  					
  					WHERE Id_Cliente=?";
  			$params = array($id_cliente);
  			$stmt = sqlsrv_query( $conn, $sql, $params);
  			if( $stmt ) {
  				$x_campos = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
  				$cliente = array_merge($cliente, $x_campos);
  			}


	  		
	  		//$row = array_map("utf8_encode", $row );
	  		$resp = array("data" => $cliente, "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
		}
	
	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}










# ==================================================================================
# 
# Datos para modificar del socio 
# updateUser=1
# 
# ==================================================================================
# 
# data (POST)
# 	{todos los datos}	ToDo: ver campos
# 
# ==================================================================================

if ($_POST["updateUser"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}

	$id_cliente = $data["id_cliente"];
	$data_estado_civil = $data["estado_civil"];
	$data_telefono = $data["telefono"];
	$data_celular = $data["celular"];
	$data_email = $data["email"];
	$data_direccion = $data["direccion"];
	$data_validado = $data["validado"];
	
	$data_cp = $data["cp"];
	$data_pais = $data["pais"];
	$data_provincia = $data["provincia"];
	$data_provincia_descrip = $data["provincia_descrip"];
	$data_localidad = $data["localidad"];
	$data_localidad_descrip = $data["localidad_descrip"];
	$data_notas = $data["notas"];
	$data_hash = $data["hash"];
	
	// xCampos Campos adicionales 180924 (VELEZ)
	if (is_array($data["xcampos"])) $data_xcampos = $data["xcampos"];

	
	

	if (!$id_cliente){
		$res = array("data" => "", "status" => 400, "message" => "Invalid Id Cliente");
		echo json_encode($res);
		exit;
	}

	$sql = "SELECT * FROM Clientes WHERE Id_Cliente=?";
	$params = array($id_cliente);
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5734763");
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
  		
  		$row = GetLastResultAssoc($stmt);
  		
		$sql = "INSERT INTO Clientes_Temp (
					Fecha, Id_Cliente, Id_Cliente_Ref, Razon_Social, Apellido, Nombre, Sexo, Estado_Civil, Fecha_Nac, 
					Id_Tipo_Doc, Doc_Nro, Direccion, Cp, Id_Pais, Id_Provincia, Provincia_Descrip, Id_Localidad, Localidad_Descrip,
					Id_Nacionalidad, Email, telefono, Tel_Movil, Json, Id_Estado_Solicitud, Observacion, Hash, Flag_Modificacion
				) VALUES (
					?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
				)";
		$params = array(
			dbdate(date("Y-m-d H:i:s")), $row["Id_Cliente"], $row["Id_Cliente_Ref"], $row["Razon_Social"], $row["Apellido"], $row["Nombre"], $row["Sexo"], $data_estado_civil, str_replace('-','', $row["Fecha_Nac"]), 
  			$row["Id_Tipo_Doc"], $row["Doc_Nro"], $data_direccion, $data_cp, $data_pais, $data_provincia, $data_provincia_descrip, $data_localidad, $data_localidad_descrip,
  			$row["Id_Nacionalidad"], $data_email, $data_telefono, $data_celular, $_POST["data"], "P", $data_notas, $data_hash, 1
		);
		//log_query($sql, $params);
		$stmt = sqlsrv_query( $conn, $sql, $params);
	  	if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				log_query($sql, $params);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5734763");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{


			// xCampos Campos adicionales 180924 (VELEZ)
	  		if (is_array($data_xcampos)){
	  			$sql = "SELECT MAX(Id_Cliente_Temp) AS id FROM Clientes_Temp";
	  			$stmt = sqlsrv_query( $conn, $sql);
	  			if ($stmt){
	  				$cliente_temp = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  				$id_cliente_temp = $cliente_temp["id"];
		  			foreach ($data_xcampos as $key => $value){
		  				if ($value["valor"] != "" || $value["valor"] > 0){
		  					
		  					$tipo = "Valor_String";
							switch (strtolower($value["tipo"])) {
							    case "string":
							        $tipo = "Valor_String";
							        break;
							    case "integer":
							        $tipo = "Valor_Integer";
							        break;
							    case "date":
							        $tipo = "Valor_DT";
							        break;
							    case "decimal":
							        $tipo = "Valor_Decimal";
							        break;
							    case "memo":
							        $tipo = "Valor_Memo";
							        break;
							    default:
							    	
							}
		  					
				  			$sql = "insert into Clientes_Temp_XCampos (Id_Cliente_Temp, Id_Campo, $tipo) values (?, ?, ?)";	// Valor_String, Valor_Integer, Valor_DT, Valor_Decimal, Valor_Memo
				  			$params = array($id_cliente_temp, $value["id"], $value["valor"]);
				  			$stmt = sqlsrv_query( $conn, $sql, $params);
				  			if (!$stmt){
					  	    	//$res = array("data" => "", "status" => 400, "message" => "Error en xcampo: " . $sql . "($id_cliente_temp, " . $value["id"] . ", " . $value["valor"] . ")");
					  	    	//$res = array("data" => "", "status" => 400, "message" => "Error en xcampo");
					  			//echo json_encode($res);
					  			//exit;
				  			}
			  			}
		  			}
	  			}
	  		}
	  	
		  	
			// Todo ok
  	    	$res = array("data" => "", "status" => 200, "message" => "");
  			echo json_encode($res);
  			exit;
		  	
	  	}
		
  	}
	
}













# ==================================================================================
# 
# Datos para modificar inscripcion 
# getTempUser=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"}
# 
# ==================================================================================

if ($_POST["getTempUser"]==1){



	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	$data_id_cliente = trim($data["id_cliente"]);
	$data_hash = trim($data["hash"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_id_cliente || $data_hash){
	
		if ($data_id_cliente){
			$sql = "select top 1 * from Clientes_Temp where id_cliente='" . $data_id_cliente . "'";
		}else{
			$sql = "select top 1 * from Clientes_Temp where Hash='" . $data_hash . "'";
		}
		$params = array();
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  		//$row = array_map("utf8_encode", $row );
	  		$resp = array("data" => $row, "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}














# ==================================================================================
# 
# Verificacion de datos para aprobar
# getUserTemp=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"}
# 
# ==================================================================================

if ($_POST["getUserTemp"]==1){



	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	$data_id_cliente = trim($data["id_cliente"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_id_cliente){
	
		$sql = "select Tel_Movil, telefono, Email,Direccion  from clientes_Temp where Id_Cliente_Temp in (
			select max(Id_Cliente_Temp)
			 from Clientes_Temp 
			where Id_Cliente ='" . $data_id_cliente . "'
			group by id_cliente)
			and( Id_Estado_Solicitud<>'A' or Id_Estado_Solicitud is null)";
		$params = array();
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
  	    		logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	  		//$row = array_map("utf8_encode", $row );
	  		$resp = array("data" => $row, "status" => 200, "message" => "");
	  		echo json_encode($resp);
	  		exit;
		}
	
	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}














/* setTempUser
<clever-autodoc>
	<function name="setTempUser">
		<name>setTempUser</name>
		<description>Inserta en Clientes_Temp un nuevo registro</description>
		<parameters>
			<item>
				<name>nuevosocio_categorias</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_id_cliente</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_Id_Tipo_Cli</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_apellido</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_nombre</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_sexo</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_estado_civil</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_fechanac</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_tipodoc</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_nrodoc</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_direccionvv</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_cp</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_pais</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_provincia</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_provincia_descrip</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_localidad</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_localidad_descrip</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_nacionalidad</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_email</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_telefono_s</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_celular_s</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_numero_temp</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_categoria</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_correo</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_hash</name>
				<type></type>
				<description></description>
			</item>
			<item>
				<name>nuevosocio_pago</name>
				<type></type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Cliente_Temp</name>
					<type>INT</type>
					<description>Codigo Id_Cliente del registro dado de alta.</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*setTempUser INICIO*/













# ==================================================================================
# 
# Datos para modificar inscripcion 
# setTempUser=1
# 
# ==================================================================================
# 
# data (POST)
# 	{todos los datos}	ToDo: ver campos
# 
# ==================================================================================

if ($_POST["setTempUser"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("ApiTest: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}


	$categorias = $data["nuevosocio_categorias"];

	// Fix Pais Provincia Localidad
	$in_nuevosocio_pais = $data["nuevosocio_pais"];
	$in_nuevosocio_provincia = $data["nuevosocio_provincia"];
	$in_nuevosocio_localidad = $data["nuevosocio_localidad"];
	if ($in_nuevosocio_localidad=="OTRO"){
		$in_nuevosocio_pais = '';
		$in_nuevosocio_provincia = '';
		$in_nuevosocio_localidad = 0;
	}
	
	//$importe_total = ($categorias[$data["nuevosocio_categoria"]]["valor"] + ($data["nuevosocio_correo"]==1?$categorias[$data["nuevosocio_categoria"]]["envio"]:0) + $categorias[$data["nuevosocio_categoria"]]["gastos"]);

	
	
	
	
	
	// Verifico si ya fue ingresado
	$sql = "select * from Clientes_Temp where Nro_Trans_Pago=? ";
	$params = array($data["nuevosocio_numero_temp"]);
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: 45453 " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573988 " . __LINE__);
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
		$row = GetLastResultAssoc($stmt);
		if ($row["Id_Cliente_Temp"]>0){
  	    	$res = array("data" => "", "status" => 200, "message" => "Ya se encuentra en la base.");
  			echo json_encode($res);
  			exit;			
		}
	}
	
	
	$valor_cuota = $categorias[$data["nuevosocio_categoria"]]["valor"];
	if ($data["nuevosocio_interior"]) $valor_cuota = $valor_cuota / 2;
	
	
	// INSERT	
	$sql = "INSERT INTO Clientes_Temp (
				Id_Cliente, Fecha, Id_Tipo_Cli, Razon_Social, Apellido, Nombre, Sexo, Estado_Civil, Fecha_Nac, Id_Tipo_Doc, Doc_Nro, Legajo, 
				Direccion, Cp, Id_Pais, Id_Provincia, Provincia_Descrip, Id_Localidad, Localidad_Descrip, Id_Nacionalidad,
				Email, telefono, Tel_Movil, Nro_Trans_Pago, Importe_CS,	Importe_GA, Importe_GE, Json, [Hash], Flag_Pago, Debito_Automatico, Debito_Automatico_Id_Tarjeta, Flag_Interior
			) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
  	$params = array(
  				(int)$data["nuevosocio_id_cliente"], 
  				date("Ymd H:i:s"), 
  				$data["nuevosocio_Id_Tipo_Cli"], 
  				$data["nuevosocio_apellido"] . " " . $data["nuevosocio_nombre"],
  				$data["nuevosocio_apellido"], 
  				$data["nuevosocio_nombre"], 
  				$data["nuevosocio_sexo"], 
  				$data["nuevosocio_estado_civil"], 
  				dbdatein($data["nuevosocio_fechanac"]), 
  				$data["nuevosocio_tipodoc"], 
  				(onlyNumbers($data["nuevosocio_nrodoc"])?$data["nuevosocio_nrodoc"]:0), 						// si doc tiene letras -> Legajo
  				(!onlyNumbers($data["nuevosocio_nrodoc"])?$data["nuevosocio_nrodoc"]:""),						// si doc tiene letras -> Legajo
  				$data["nuevosocio_direccion"], 
  				$data["nuevosocio_cp"], 
  				$in_nuevosocio_pais, 
  				$in_nuevosocio_provincia, 
  				$data["nuevosocio_provincia_descrip"], 
  				(int)$in_nuevosocio_localidad, 
  				$data["nuevosocio_localidad_descrip"], 
  				$data["nuevosocio_nacionalidad"], 
  				$data["nuevosocio_email"], 
  				$data["nuevosocio_telefono_s"], 
  				$data["nuevosocio_celular_s"],
  				$data["nuevosocio_numero_temp"], 																// Nro trans pago
  				$valor_cuota,																					// @pImporteCS
  				$categorias[$data["nuevosocio_categoria"]]["gastos"],											// @pImporteGA
  				($data["nuevosocio_correo"]==1?$categorias[$data["nuevosocio_categoria"]]["envio"]:0),			// @pImporteGE
  				json_encode($data),																				// Guardo toda la info en json
  				$data["nuevosocio_hash"], 
  				$data["nuevosocio_pago"],																		// P Pagado I Impago R Rechazado
  				$data["nuevosocio_debito_tarjeta"],																// Tarjeta Debito Automatico
  				$data["nuevosocio_debito_id_tarjeta"],
  				$data["nuevosocio_interior"]																	// Si es socio del interior
  	);
  	//log_query($sql, $params);
  	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
			log_query($sql, $params);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: 45453 " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573988 " . __LINE__);
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
  	
		// ID CLIENTE TEMP
		$sql = "SELECT MAX(ISNULL(Id_Cliente_Temp,0)) as Id_Cliente_Temp FROM Clientes_Temp";
		$params = array();
		$stmt = sqlsrv_query( $conn, $sql, $params);
	  	if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: 45345 " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5465465");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
			$row = GetLastResultAssoc($stmt);
			$id_cliente_temp = $row["Id_Cliente_Temp"];
		}
  	
  		//$row = GetLastResultAssoc($stmt);
  		//$id_cliente_temp = $row["Id_Cliente_Temp"];
  		
  		// Guarda las imagenes/archivos
  		if ($_FILES){

  			$item = 1;
  			foreach ($_FILES as $key => $ffile) {
  			
  				if ($ffile["error"]==0 && $ffile["size"]>0){
  				
  					// lee archivo
  					$filename = $ffile["tmp_name"];
					$handle = fopen($filename, "r");
					$contents = fread($handle, filesize($filename));
					fclose($handle);
  				
	  				$sql = "insert into Clientes_Temp_Doc (Id_Cliente_Temp, Item, Descripcion, Extension, Documento) VALUES (?, ?, ?, ?, ? )";
	  				$params = array($id_cliente_temp, $item, $key, get_ext($ffile["name"]), 
		  				array($contents, 
	                      SQLSRV_PARAM_IN, 
	                      SQLSRV_PHPTYPE_STRING(SQLSRV_ENC_BINARY), 
	                      SQLSRV_SQLTYPE_VARBINARY('max'))
	  				);
					$stmt = sqlsrv_prepare($conn, $sql, $params);
	  				$stmt = sqlsrv_execute($stmt);
	  				
					//$stmt = sqlsrv_query( $conn, $sql, $params );
					if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error 453455: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573984");
				  			echo json_encode($res);
				  			exit;
				  	    }
					}
  					$item++;
  				}
  			}
  			
  			
  			// XCAMPOS:
  			
  			// xCampos Campos adicionales 180924 (VELEZ)
  			
  			// [dbo].[CP_xCampos_Guardar] @pTabla VARCHAR(50), @pId VARCHAR(100), @pId_Campo INT, 
  			// @pValor_String VARCHAR(101),@pValor_Integer INT,@pValor_DT DATETIME,@pValor_Decimal DECIMAL(20,4),@pValor_Memo TEXT
  			
  			if ($data["nuevosocio_x_discapacitado"]){
				$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
		  		$params = array($id_cliente_temp, 			2, null, 			$data["nuevosocio_x_discapacitado"], null, null, null);
		  		$stmt = sqlsrv_query( $conn, $sql, $params );
	  		}
	  		
	  		if ($data["nuevosocio_x_tipodiscapacidad"]){
				$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
		  		$params = array($id_cliente_temp, 			3, 					$data["nuevosocio_x_tipodiscapacidad"], null, null, null, null);
		  		$stmt = sqlsrv_query( $conn, $sql, $params );
	  		}
	  		
	  		if ($data["nuevosocio_x_nrodecredencial"]){
				$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
		  		$params = array($id_cliente_temp, 			4, null, 			$data["nuevosocio_x_nrodecredencial"], null, null, null);
		  		$stmt = sqlsrv_query( $conn, $sql, $params );
	  		}
			
	  		if ($data["nuevosocio_x_obsdiscapacidad"]){
				$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
		  		$params = array($id_cliente_temp, 			5, 					$data["nuevosocio_x_obsdiscapacidad"], null, null, null, null);
		  		$stmt = sqlsrv_query( $conn, $sql, $params );
	  		}
	  		
	  		if ($data["nuevosocio_x_fechadevencimiento"]){
				$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
		  		$params = array($id_cliente_temp, 			6, null, null, 		dbdatein($data["nuevosocio_x_fechadevencimiento"]), null, null);
		  		$stmt = sqlsrv_query( $conn, $sql, $params );
	  		}
			
  			
			// Notificaciones x email -> nuevosocio_flag_comunic_email
			//$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
	  		//$params = array($id_cliente, 37, $data["nuevosocio_secretaria"], null, null, null, null);
	  		//$stmt = sqlsrv_query( $conn, $sql, $params );
  			
			// Notificaciones x sms -> nuevosocio_flag_comunic_sms
			//$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
	  		//$params = array($id_cliente, 37, $data["nuevosocio_secretaria"], null, null, null, null);
	  		//$stmt = sqlsrv_query( $conn, $sql, $params );
  			
			// Celular verificado -> nuevosocio_celular_verificado
			//$sql = "EXEC CP_xCampos_Guardar 'CLIENTETEMP', ?, ?,  ?, ?, ?, ?, ?";
	  		//$params = array($id_cliente, 37, $data["nuevosocio_secretaria"], null, null, null, null);
	  		//$stmt = sqlsrv_query( $conn, $sql, $params );

  			
  		}else{
  		
  	    	//$res = array("data" => "", "status" => 400, "message" => "NO FILES");
  			//echo json_encode($res);
  			//exit;
  		
  		}
  		$resp = array("data" => $row, "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
  	}
	
	



	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}
/*setTempUser FIN*/









# ==================================================================================
# 
# Busca la existencia de un socio x DNI
# esSocioDni=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_provincia":"1"}
# 
# ==================================================================================

if ($_POST["esSocioDni"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	$data_dni = trim($data["dni"]);

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	if ($data_dni){
	
		$sql = "select Id_Cliente, Doc_Nro from clientes where Doc_Nro=? or Legajo=?";
		$params = array($data_dni, $data_dni);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
			if ($row["Id_Cliente"]>0){
	  			$resp = array("data" => array("cliente" => $row), "status" => 200, "message" => "");
	  		}else{
	  			$resp = array("data" => array("cliente" => array("Id_Cliente" => 0, "Doc_Nro" => 0)), "status" => 200, "message" => "");
	  		}
	  		echo json_encode($resp);
	  		exit;
		}

	}

	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}








# ==================================================================================

?>