<?

/*

FSER:

- contratos						Listado de Contratos del Socio
- contrato_debito				ABM Debito Automatico
- Abonos_Anteriores				Busca si ya tiene abonos en el periodo



*/



# ==================================================================================
# 
# Listado de Contratos del Socio
# contratos=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"}
# 
# ==================================================================================

if ($_POST["contratos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_cliente = trim($data["id_cliente"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_id_cliente){
		$sql = "SELECT c.*, ct.Descripcion as Contrato_Descripcion1, dbo.CF_Contrato_Descrip(c.Id_Contrato) as Contrato_Descripcion
					FROM contratos c
					left join Contratos_Tipos ct on c.Id_Tipo_Con=ct.Id_Tipo_Con
					WHERE c.Activo=1
					and c.Id_Cliente = ?";
		$params = array($data_id_cliente);
	  	$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
	  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
	  			$contratos[] = $row;
	  		}
	  	}
		
  		$resp = array("data" => array("contratos" => $contratos), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
		
		
		
	}
	
	
	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}








# ==================================================================================
# 
# Debitos automaticos / ABM
# contrato_debito=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_contrato":"12345", "id_cliente":"12345", "id_tarjeta":"02", "tar_nro":"12345", "borrar":0/1}
# 
# ==================================================================================
if ($_POST["contrato_debito"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_contrato = trim($data["id_contrato"]);
	$data_id_cliente = trim($data["id_cliente"]);
	$data_id_multiple = trim($data["id_multiple"]);
	
	$data_id_tarjeta = trim($data["id_tarjeta"]);
	$data_nro_tarjeta = trim($data["tar_nro"]);
	$data_borrar = trim($data["borrar"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}


	if ((!$data_id_contrato || !$data_id_cliente) && !$data_id_multiple){
		$res = array("data" => "", "status" => 400, "message" => "Error 485687");
		echo json_encode($res);
		exit;
	}
	
	
	if (!$data_id_multiple){
		$data_id_multiple[] = array("id_contrato" => $data_id_contrato, "id_cliente" => $data_id_cliente);
	}else{
		$data_id_multiple = json_decode($data_id_multiple, true);
		$data_jsonerror = json_last_error();
		if ($data_jsonerror){
			$res = array("data" => "", "status" => 500, "message" => "Invalid JSON Data");
			echo json_encode($res);
			exit;
		}
	}
	
	if (!is_array($data_id_multiple)){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON Data 45387");
		echo json_encode($res);
		exit;
	}
	
	
	
	

	
	
	
	
	
	
	if ($data_borrar==1){
		foreach ($data_id_multiple as $key => $value){
			if ($value["id_contrato"]>0 && $value["id_cliente"]>0){
				$sql = "UPDATE Contratos set Id_Tarjeta=null, Tar_Nro=null where Id_Contrato=? AND Id_Cliente=?";
				$params = array($value["id_contrato"], $value["id_cliente"]);
			  	$stmt = sqlsrv_query( $conn, $sql, $params);
				if( $stmt === false ) {
			  	    if(($errors = sqlsrv_errors()) != null){
			  	    	logError("Error: " . $errors[0]["message"], __LINE__);
			  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
			  			echo json_encode($res);
			  			exit;
			  	    }else{
			  	    	logError("Error sql 8573987", __LINE__);
						$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
			  			echo json_encode($res);
			  			exit;
			  	    }
			  	}
		  	}else{
  	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5879455");
  	  			echo json_encode($res);
  	  			exit;
		  	}

		}
		// todo ok
	  	$res = array("data" => "", "status" => 200, "message" => "DA Borrado");
	  	echo json_encode($res);
	  	exit;
	}

  	foreach ($data_id_multiple as $key => $value){
  		if ($value["id_contrato"]>0 && $value["id_cliente"]>0){
			$sql = "UPDATE Contratos set Id_Tarjeta=?, Tar_Nro=? where Id_Contrato=? AND Id_Cliente=?";
			$params = array($data_id_tarjeta, $data_nro_tarjeta, $value["id_contrato"], $value["id_cliente"]);
		  	$stmt = sqlsrv_query( $conn, $sql, $params);
			if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	logError("Error sql 8573987", __LINE__);
					$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}
		}else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 3478575");
  			echo json_encode($res);
  			exit;
		}
	}
	
	// todo ok
  	$resp = array("data" => "", "status" => 200, "message" => "DA Ingresado");
  	echo json_encode($resp);
  	exit;

	
}




# ==================================================================================
# 
# Abonos anteriores
# Abonos_Anteriores=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1", "fecha_desde":"20180101", "fecha_hasta":"20180631"}
# 
# ==================================================================================
if ($_POST["Abonos_Anteriores"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	$data_id_cliente = trim($data["id_cliente"]);
	$data_fecha_desde = trim($data["fecha_desde"]);
	$data_fecha_hasta = trim($data["fecha_hasta"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		logError("Invalid JSON", __LINE__);
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}

	/*
	$sql = "SELECT  
				CASE WHEN LEFT(A.Id_producto , 2) in ('KN','LN','MN','NN','ON','QN','FN','GN','HN','IN','JN','RN','SN','TN','UN','VN') THEN 1 
						WHEN LTRIM(RTRIM(A.Id_producto)) in ('751','75163') THEN 1
					END as norte,
				CASE WHEN LEFT(A.Id_producto , 2) in ('ES','DS','CS','BS','AS','JS','IS','HS','GS','FS','75153') THEN 1 
						WHEN LTRIM(RTRIM(A.Id_producto)) in ('75153') THEN 1
					END as sur,
				CASE WHEN LEFT(A.Id_producto , 2) in ('1P','2P','B3','A1','A2','B1','B2','B4','B5','B6','B7','B8') THEN 1 END as palco,
				CASE WHEN LTRIM(RTRIM(A.Id_producto)) in ('75143','75123','7551') THEN 1 END as estacionamiento,
				1 as ocupado
				,A.Id_producto 
				,p.Descripcion_Detallada
				FROM Cbtes_Items A, Cbtes B ,Cbtes_Tipos C , Productos P
				WHERE A.Id_Trans = B.Id_Trans 
					AND B.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
					AND A.Id_Producto = P.Id_Producto 
					AND A.Flag_QA = 'A' 
					AND B.Id_Estado_Cbte NOT IN (3,0)
					AND (C.Compromete_Factura = 1 OR C.Compromete_Remitos = 1 OR C.Compromete_Pedido = 1) 
					AND P.Tipo = 'L'
					AND A.Fecha_QA <=  ?
					AND ISNULL(A.Fecha_Venc,GETDATE() + 5000) >=  '20180530'
					AND A.Id_Cliente=?
			";
	*/
	
	$sql = "EXEC CP_Abonos_Plateas_Anteriores ?, ?, ?, ? ";		//@pId_Cliente, @pFecha_QA, '20180530', 5000
	$params = array($data_id_cliente, $data_fecha_desde, $data_fecha_hasta, 5000);	//$data_fecha_desde, $data_fecha_hasta
  	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
    	    if(($errors = sqlsrv_errors()) != null){
    	    	logError("Error: " . $errors[0]["message"], __LINE__);
    	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
    			echo json_encode($res);
    			exit;
    	    }else{
    	    	logError("Error sql 8573987", __LINE__);
    	    	$res = array("data" => "", "status" => 400, "message" => "Error 8475893");
    			echo json_encode($res);
    			exit;
    	    }
  	}else{
  		while (sqlsrv_next_result($stmt)){
	  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				if ($row["norte"]){
					$tiene_norte = 1;
					$cantidad_platea_norte++;
					$plateas_norte[] = $row["cod_prod"];
				}
				if ($row["sur"]){
					$tiene_sur = 1;
					$cantidad_platea_sur++;
					$plateas_sur[] = $row["cod_prod"];
				}
				
				$tiene_estacionamiento = 0; // ToDo: ???
				
			}
		}
  		$resp = array(	"id_cliente" => $data_id_cliente, 
  						"tiene_norte" => $tiene_norte, "cantidad_platea_norte" => $cantidad_platea_norte, "plateas_norte" => $plateas_norte,
  						"tiene_sur" => $tiene_sur, "cantidad_platea_sur" => $cantidad_platea_sur, "plateas_sur" => $plateas_sur,
  						"tiene_estacionamiento" => $tiene_estacionamiento
  					);
  		$resp = array("data" => $resp, "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
  	}


	// final de codigo - error
	logError("Incorrect Data", __LINE__);
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}







# ==================================================================================

?>