<?

/*
<clever-autodoc>
	<file name="datos.php">
		<name>datos.php</name>
		<last_update>07/02/2020 09:06Hs</last_update>
		<updates>
			<item>
				<date>07/02/2020 09:06Hs</date>
				<description>Se agregó el método: Clientes_Credencial_Nueva</description>
			</item>
			<item>
				<date>13/06/2019 13:00Hs</date>
				<description>Se agregó el método: Validar_FK</description>
			</item>
			<item>
				<date>20/03/2019 17:10Hs</date>
				<description>Se agregó el método: CF_xParam</description>
			</item>
			<item>
				<date>01/03/2019 12:44Hs</date>
				<description>Se agregó el método: CF_Seg_User_Validar</description>
			</item>
			<item>
				<date>25/02/2019 16:17Hs</date>
				<description>Se paso la funcion login de index.php a datos.php</description>
			</item>
			<item>
				<date>22/02/2019 12:39Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getEstructuraBrowse</name>
				<description>Llama al Stored Procedure: CP_Estructura_Browse para devolver la estructura de la respuesta de un Stored Procedure que genera un BROWSE</description>
			</item>
			<item>
				<name>getEstructuraForm</name>
				<description>	Llama al Stored Procedure: CP_Estructura_Form para devolver la estructura de la respuesta de un Stored Procedure que genera un FORM</description>
			</item>
			<item>
				<name>logon</name>
				<description>Llama a la función: CF_Login_Sistema para determinar si el login al Sistema es exitoso</description>
			</item>
			<item>
				<name>login</name>
				<description>Llama al Stored: CP_Login_Extranet para determinar si el login a la extranet es exitosa</description>
			</item>
			<item>
				<name>getClientesFoto</name>
				<description>Devuelve un String con la foto del cliente en formato BASE64</description>
			</item>
			<item>
				<name>CF_Seg_User_Validar</name>
				<description>Llama la función: CF_Seg_User_Validar para determinar si un usuario tiene permiso a una puerta (eQuate).</description>
			</item>
			<item>
				<name>Validar_FK</name>
				<description>Valida si el dato pasado existe en la columna de la tabla indicada.</description>
			</item>
			<item>
				<name>Clientes_Credencial_Nueva</name>
				<description>Asigna a un cliente una nueva credencial.</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/*
<clever-autodoc>
	<function name="getEstructuraBrowse">
		<name>getEstructuraBrowse</name>
		<description>Llama al Stored Procedure: CP_Estructura_Browse para devolver la estructura de la respuesta de un Stored Procedure que genera un BROWSE</description>
		<parameters>
			<item>
				<name>pStoredProcedure</name>
				<type>VARCHAR(255)</type>
				<description>Nombre del Stored Procedure del Browse del que se quiere adquirir la estructura</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Dato</name>
					<type>VARCHAR(50)</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Tipo_Dato</name>
					<type>VARCHAR(50)</type>
					<description>VARCHAR | INT | DATE ...</description>
				</item>
				<item>
					<name>Flag_Dato</name>
					<type>CHAR(1)</type>
					<description>P: Parametro de Entrada | C: Campo Respuesta</description>
				</item>
				<item>
					<name>Posicion_Dato</name>
					<type>SMALLINT</type>
					<description>Numero de Posicion de llamada de Parámetro o Posición en Query de Respuesta según corresponda con Flag_Dato</description>
				</item>
				<item>
					<name>Visible</name>
					<type>TINYINT</type>
					<description>1: Visible | 0: No Visible. Para Flag_Dato = 'P' se ignora</description>
				</item>
				<item>
					<name>Filtrable</name>
					<type>TINYINT</type>
					<description>1: Dato Filtrable | 0: Dato no filtrable</description>
				</item>
				<item>
					<name>Tipo_Filtro</name>
					<type>SMALLINT</type>
					<description>Ver Anexo. Para Filtrable = 0 lo ignora</description>
				</item>
				<item>
					<name>Valores_Combo</name>
					<type>VARCHAR(8000)</type>
					<description>Valores posibles para Tipo_Filtro = 50. Formato: Id,Descripcion;Id,Descripcion..</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getEstructuraBrowse INICIO*/
if ($_POST["getEstructuraBrowse"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getEstructuraBrowse: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pStoredProcedure = $data["pStoredProcedure"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pStoredProcedure){
		
		$sql = "EXEC CP_Estructura_Browse ?";
		$params = array($pStoredProcedure);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getEstructuraBrowse: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getEstructuraBrowse: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}

	}else{
		logError("getEstructuraBrowse: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getEstructuraBrowse FIN*/



/*
<clever-autodoc>
	<function name="getEstructuraForm">
		<name>getEstructuraForm</name>
		<description>Llama al Stored Procedure: CP_Estructura_Form para devolver la estructura de la respuesta de un Stored Procedure que genera un Browse</description>
		<parameters>
			<item>
				<name>pStoredProcedure</name>
				<type>VARCHAR(255)</type>
				<description>Nombre del Stored Procedure del Form del que se quiere adquirir la estructura</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>			
				<item>
					<name>Id_Dato</name>
					<type>VARCHAR(50)</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Titulo_Campo</name>
					<type>VARCHAR(50)</type>
					<description>Nombre del Titulo en el Form</description>
				</item>
				<item>
					<name>Tipo_Dato</name>
					<type>VARCHAR(50)</type>
					<description>VARCHAR | INT | DATE ...</description>
				</item>
				<item>
					<name>Flag_Dato</name>
					<type>CHAR(1)</type>
					<description>P: Parametro de Entrada | E: Elemento de Form</description>
				</item>
				<item>
					<name>Posicion_Dato</name>
					<type>SMALLINT</type>
					<description>Numero de Posicion de llamada de Parámetro. Para Flag_Dato = E se ignora</description>
				</item>
				<item>
					<name>Posicion_Visual</name>
					<type>SMALLINT</type>
					<description>Posición de Orden Visual en el Formulario.</description>
				</item>
				<item>
					<name>Tam_Elem</name>
					<type>INT</type>
					<description>Tamaño del Elemento, cuando ocupa en pantalla</description>
				</item>
				<item>
					<name>Visible</name>
					<type>TINYINT</type>
					<description>1: Visible | 0: No Visible. Para Flag_Dato = 'P' se ignora</description>
				</item>
				<item>
					<name>Tipo_Elemento</name>
					<type>SMALLINT</type>
					<description>Ver Anexo dentro del Stored.</description>
				</item>
				<item>
					<name>Valores_Combo</name>
					<type>VARCHAR(8000)</type>
					<description>Valores posibles para Tipo_Filtro = 50. Formato: Id,Descripcion;Id,Descripcion...</description>
				</item>
				<item>
					<name>Valor_Defecto</name>
					<type>VARCHAR(8000)</type>
					<description>Valor del Campo por defcto.</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getEstructuraForm INICIO*/
if ($_POST["getEstructuraForm"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getEstructuraForm: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pStoredProcedure = $data["pStoredProcedure"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pStoredProcedure){
		
		$sql = "EXEC CP_Estructura_Form ?";
		$params = array($pStoredProcedure);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_SCA_IdControlador: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_SCA_IdControlador: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getEstructuraForm: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getEstructuraForm FIN*/



/*
<clever-autodoc>
	<function name="logon">
		<name>logon</name>
		<description>Login de Usuario del Sistema, llama a la funcion: CF_Login_Sistema</description>
		<parameters>
			<item>
				<name>pUsuario</name>
				<type>VARCHAR(41)</type>
				<description>Usuario del Sistema CleverSoft. (Ej. Nombre y apellido separado por un espacio)</description>
			</item>
			<item>
				<name>pPassword</name>
				<type>VARCHAR(20)</type>
				<description>Password del sistema CleverSoft</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Login_Exitoso</name>
					<type>INT</type>
					<description>Id_Usuario de la tabla Seg_Usuarios</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*logon INCIO*/
if ($_POST["logon"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("logon: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pUsuario = $data["pUsuario"];
	$pPassword = $data["pPassword"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pUsuario && $pPassword){
		
		$sql = "SELECT dbo.CF_Login_Sistema(?, ?) AS Flag_Login_Exitoso";
		$params = array($pUsuario, $pPassword);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("logon: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("logon: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$Flag_Login_Exitoso = $row["Flag_Login_Exitoso"];
			
	  		$res = array("data" => array("Flag_Login_Exitoso" => $Flag_Login_Exitoso), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}	
	}else{
		logError("logon: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*logon FIN*/





/*
<clever-autodoc>
	<function name="getClientesFoto">
		<name>getClientesFoto</name>
		<description>Devuelve un String con la foto del cliente en formato BASE64</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente del cual se desea recuperar la foto</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>foto</name>
					<type>VARCHAR(MAX)</type>
					<description>Foto del Cliente en VARCHAR - BASE64</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getClientesFoto INCIO*/
if ($_POST["getClientesFoto"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getClientesFoto: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Cliente = $data["pId_Cliente"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente != 0){	  		

		//Busca primero en Clientes_Fotos
		$sql = "SELECT CAST(N'' AS XML).value('xs:base64Binary(xs:hexBinary(sql:column(\"Foto\")))', 'VARCHAR(MAX)') AS FotoBase
				FROM (SELECT  CONVERT(VARBINARY(MAX), Foto) AS Foto FROM Clientes_Fotos WHERE Id_Cliente = " .$pId_Cliente. ") AS bin_sql_server_temp";
		$stmt = sqlsrv_query( $conn, $sql);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getClientesFoto: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getClientesFoto: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK (Clientes_Fotos)
			$row = GetLastResultAssoc($stmt);
			$fotoBase = $row["FotoBase"];

			if(strcmp($fotoBase, '') != 0)
			{
				//La foto esta directamente en Clientes_Fotos
				$foto = "data:".$check["mime"].";base64,".$fotoBase;
			
				$res = array("data" => array("foto" => $foto), "status" => 200, "message" => "");
				echo json_encode($res);
				exit;
			}else{				
				//La foto no esta en Clientes_Fotos, Busca si esta el archivo
				$sql = "SELECT LTRIM(RTRIM(ISNULL(Foto, ''))) AS Foto FROM Clientes WHERE Id_Cliente = " .$pId_Cliente;
				$stmt = sqlsrv_query( $conn, $sql);
				
				if( $stmt === false ) {
					//Verifica si se trata de un error de SQL
					if(($errors = sqlsrv_errors()) != null){
						logError("getClientesFoto: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
						$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
						echo json_encode($res);
						exit;
					}else{
						logError("getClientesFoto: Error sin descripcion", __LINE__);
						$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
						echo json_encode($res);
						exit;
					}
				}else{
					//Resultado consulta SQL OK (Clientes, campo foto)
					$row = GetLastResultAssoc($stmt);
					$ruta_foto = $row["Foto"];

					if(strcmp($ruta_foto, '') != 0)
					{
						$data = base64_encode(file_get_contents($ruta_foto));
						$foto = "data:".$check["mime"].";base64,".$data;
					
						$res = array("data" => array("foto" => $foto), "status" => 200, "message" => "");
						echo json_encode($res);
						exit;
					}else{
						logError("getClientesFoto: No Existe la foto(Ni Clientes_Fotos ni archivo). Id_Cliente: ".$pId_Cliente, __LINE__);
						$res = array("data" => "", "status" => 500, "message" => "No existe foto");
						echo json_encode($res);
						exit;
					}			
				}
			}			
		}				
	}else{
		logError("getClientesFoto: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getClientesFoto FIN*/



/*
<clever-autodoc>
	<function name="CF_Seg_User_Validar">
		<name>CF_Seg_User_Validar</name>
		<description>Llama la función: CF_Seg_User_Validar para determinar si un usuario tiene permiso a una puerta (eQuate).</description>
		<parameters>
			<item>
				<name>pId_Usuario</name>
				<type>SMALLINT</type>
				<description>Id_Usuario del Sistema CleverSoft.</description>
			</item>
			<item>
				<name>pEquate</name>
				<type>VARCHAR(30)</type>
				<description>Equate de la puerta (Columna equate de la Tabla Seg_Door)</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Permiso_Exitoso</name>
					<type>TINYINT</type>
					<description>1: Acceso permitido a la puerta, 0: Acceso denegado a la puerta</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_Seg_User_Validar INCIO*/
if ($_POST["CF_Seg_User_Validar"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_Seg_User_Validar: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Usuario = $data["pId_Usuario"];
	$pEquate = $data["pEquate"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Usuario && $pEquate != ""){
		
		$sql = "SELECT dbo.CF_Seg_User_Validar(?, ?) AS Flag_Permiso_Exitoso";
		$params = array($pId_Usuario, $pEquate);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_Seg_User_Validar: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_Seg_User_Validar: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$Flag_Permiso_Exitoso = $row["Flag_Permiso_Exitoso"];
			
	  		$res = array("data" => array("Flag_Permiso_Exitoso" => $Flag_Permiso_Exitoso), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}	
	}else{
		logError("CF_Seg_User_Validar: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_Seg_User_Validar FIN*/



/*
<clever-autodoc>
	<function name="CF_xParam">
		<name>CF_xParam</name>
		<description>Llama la función: CF_xParam para determinar el valor de un parametro.</description>
		<parameters>
			<item>
				<name>pId_Parametro</name>
				<type>VARCHAR(20)</type>
				<description>Nombre del Parametro.</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Valor_Parametro</name>
					<type>VARCHAR(8000)</type>
					<description>Valor del parametro sin importar el tipo</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CF_xParam INCIO*/
if ($_POST["CF_xParam"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CF_xParam: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Parametro = $data["pId_Parametro"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Parametro){
		
		$sql = "SELECT dbo.CF_xParam(?) AS Valor_Parametro";
		$params = array($pId_Parametro);
	  	$stmt = sqlsrv_query( $conn, $sql, $params );
		
	  	//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CF_xParam: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CF_xParam: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	  		//Resultado consulta SQL OK
			$row = GetLastResultAssoc($stmt);
			$Valor_Parametro = $row["Valor_Parametro"];
			
	  		$res = array("data" => array("Valor_Parametro" => $Valor_Parametro), "status" => 200, "message" => "");
			echo json_encode($res);
			exit;	  		
	  	}	
	}else{
		logError("CF_xParam: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CF_xParam FIN*/

/*
<clever-autodoc>
	<function name="Validar_FK">
		<name>Validar_FK</name>
		<description>Valida si el dato pasado existe en la columna de la tabla indicada</description>
		<parameters>
			<item>
				<name>pTabla</name>
				<type>VARCHAR(100)</type>
				<description>Tabla donde buscar</description>
			</item>
			<item>
				<name>pCampo</name>
				<type>VARCHAR(100)</type>
				<description>Campo de la tabla donde buscar</description>
			</item>
			<item>
				<name>pDato</name>
				<type>VARCHAR(MAX)</type>
				<description>Dato a buscar en el campo de la tabla</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Existe_Dato_En_Tabla</name>
					<type>TINYINT</type>
					<description>0: No existe el dato en el campo de la tabla. 1: Existe el dato en el campo de la tabla.</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*Validar_FK INICIO*/
if ($_POST["Validar_FK"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("Validar_FK: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pTabla = $data["pTabla"];
	$pCampo = $data["pCampo"];
	$pDato = $data["pDato"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pTabla || $pCampo || $pDato){
		
		$sql = 	"SELECT ISNULL((
				SELECT MAX(1) FROM " . $pTabla .
				" WHERE " .
				$pCampo. " = '". $pDato . "'), 0) AS Flag_Existe_Dato_En_Tabla";
				
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Validar_FK: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("Validar_FK: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{			
			//Resultado consulta SQL OK
			$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
				
			$res = array("data" => $row, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;						
		}

	}else{
		logError("Validar_FK: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*Validar_FK FIN*/


/*
<clever-autodoc>
	<function name="Clientes_Credencial_Nueva">
		<name>Clientes_Credencial_Nueva</name>
		<description>Asigna a un cliente una nueva credencial.</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente que se quiere cambiar la credencial</description>
			</item>
			<item>
				<name>pCredencial_Nro</name>
				<type>VARCHAR(30)</type>
				<description>Numero de Credencial_Nro</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Flag_Existe_Dato_En_Tabla</name>
					<type>TINYINT</type>
					<description>0: No existe el dato en el campo de la tabla. 1: Existe el dato en el campo de la tabla.</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*Clientes_Credencial_Nueva INICIO*/
if ($_POST["Clientes_Credencial_Nueva"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("Clientes_Credencial_Nueva: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Cliente 		= (int)$data["pId_Cliente"];
	$pCredencial_Nro 	= $data["pCredencial_Nro"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente || $pCredencial_Nro){
		
		//Actualiza el campo Credencial_Nro en la tabla clientes
		$sql = "UPDATE Clientes SET Credencial_Nro = RTRIM(LTRIM('" . $pCredencial_Nro. "')) WHERE Id_Cliente = ".$pId_Cliente;
				
		$params = array();
					
		$stmt = sqlsrv_prepare($conn, $sql, $params);
		$stmt = sqlsrv_execute($stmt);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Clientes_Credencial_Nueva: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("Clientes_Credencial_Nueva: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{			
			//Resultado consulta SQL OK
			$resp = array("Id_Cliente" => $pId_Cliente);
			$res = array("data" => $resp, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;						
		}

	}else{
		logError("Clientes_Credencial_Nueva: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*Clientes_Credencial_Nueva FIN*/

?>