<?
/*
<clever-autodoc>
	<file name="d_isis.php">
		<name>d_isis.php</name>
		<last_update>13/03/2019 16:43Hs</last_update>
		<updates>
			<item>
				<date>13/03/2019 16:43Hs</date>
				<description>Se agregó el metodo: api_sqlsrv_query</description>
			</item>
			<item>
				<date>26/02/2019 16:52Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getEmpresasMaster</name>
				<description>Obtiene las empresas disponibles de la Base Master</description>
			</item>
			<item>
				<name>api_sqlsrv_query</name>
				<description>Ejecuta un query genérico</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/*
<clever-autodoc>
	<function name="getEmpresasMaster">
		<name>getEmpresasMaster</name>
		<description>Obtiene las empresas disponibles de la Base Master</description>
		<parameters>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Empresa</name>
					<type>SMALLINT</type>
					<description>Codigo de la empresa</description>
				</item>
				<item>
					<name>Razon_Social</name>
					<type>VARCHAR(100)</type>
					<description>Nombre de la empresa</description>
				</item>
				<item>
					<name>Cuit</name>
					<type>VARCHAR(13)</type>
					<description>Cuit de la empresa</description>
				</item>
				<item>
					<name>Logo_Rpt</name>
					<type>VARCHAR(254)</type>
					<description>Ruta de donde se encuentra la imagen del logo</description>
				</item>
				<item>
					<name>Nombre_DB</name>
					<type>VARCHAR(200)</type>
					<description>Nombre de la Base de Datos</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getEmpresasMaster INCIO*/
if ($_POST["getEmpresasMaster"]==1){
	

	$sql = "SELECT Id_Empresa, 
			ISNULL(Razon_Social, '') AS Razon_Social, 
			ISNULL(Cuit, '') AS Cuit, 
			ISNULL(Logo_Rpt, '') AS Logo_Rpt, 
			ISNULL(Nombre_DB, '') AS Nombre_DB
			FROM Empresas";
	$params = array($pId_Usuario);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	
	//Verifica si hay algun error al ejecutar la consulta
	if( $stmt === false ) {
		//Verifica si se trata de un error de SQL
		if(($errors = sqlsrv_errors()) != null){
			logError("getEmpresasMaster: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
			$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
			echo json_encode($res);
			exit;
		}else{
			logError("getEmpresasMaster: Error sin descripcion", __LINE__);
			$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
			echo json_encode($res);
			exit;
		}
	}else{
		//Resultado consulta SQL OK
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			$res[] = $row;
		}

		$resp = array("data" => $res, "status" => 200, "message" => "");			
		echo json_encode($resp);			
		exit;
	}
	
}
/*getEmpresasMaster FIN*/


?>