<?

# ==================================================================================
# 
# Ingreso de Pagos
# setPayment=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"} toda la info de decidir
# 
# ==================================================================================


$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

// verifica si el json es valido
if ($jsonerror){
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}

$data_id_cliente 			= $data["id_cliente"];
$data_id_cliente_externo 	= $data["id_cliente_externo"];
$data_razon_social 			= $data["razon_social"];
$data_email  				= $data["email"];
$data_noperacion 			= $data["noperacion"];
$data_transacciones 		= $data["transacciones"];
$data_productos 			= $data["productos"];
$data_info_pago  			= $data["info_pago"];
$importe_total 				= 0; 
$cone 						= ""; 
$transac_list 				= "";
foreach ($data_transacciones as $key => $value){
	$importe_total += $value["importe"];
	$transac_list .= $cone . $value["id_trans"];
	$cone = ",";
}
foreach ($data_productos as $key => $value){
	$importe_total += $value["importe"];
}
if (!$importe_total){
	$res = array("data" => "", "status" => 400, "message" => "Importe total 0 - 834758");
	echo json_encode($res);
	exit;
}



// Verifico si alguna transaccion ya fue pagada antes
$sql = "select Id_Trans from Cbtes where Id_Trans in (" . $transac_list . ") and Id_Estado_Cbte=2";
$params = array();
$stmt = sqlsrv_query( $conn, $sql, $params);
log_query($sql, $params);
if( $stmt === false ) {
    sql_error(sqlsrv_errors(), "Error CDPS001" , __LINE__, __FILE__ );
}else{
	$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	if ($row["Id_Trans"]>0){
		$res = array("data" => "", "status" => 400, "message" => "Error 4863875 Trans pagado");
		echo json_encode($res);
		exit;
	}
}



$Per_Caja_Cob_Web 		= xparam_fetch('Per_Caja_Cob_Web',$conn);
$Tip_Cbte_Cob_Web 		= xparam_fetch('Tip_Cbte_Cob_Web',$conn);
$Tipo_Cbte_Web_Inst 	= xparam_fetch('Tipo_Cbte_Web_Inst',$conn);
$Id_Cta_Baco_CWeb 		= xparam_fetch('Id_Cta_Baco_CWeb',$conn);

if (!$Per_Caja_Cob_Web || !$Tip_Cbte_Cob_Web || !$Tipo_Cbte_Web_Inst){
	$res = array("data" => "", "status" => 400, "message" => "No Per_Caja_Cob_Web o Tip_Cbte_Cob_Web definidos en xparam");
	echo json_encode($res);
	exit;
}




// 190612 G.  -->
$Tipo_Cbte = $Tip_Cbte_Cob_Web;

$sql = "SELECT Id_Unid_Negocio FROM cbtes C, Cbtes_Tipos CT 
		WHERE C.Id_Tipo_Cbte=CT.Id_Tipo_Cbte AND C.Id_Trans = ?";
$params = array($data_transacciones[0]["id_trans"]);
log_query($sql, $params);
$stmt = sqlsrv_query( $conn, $sql, $params);
log_query($sql, $params);
if( $stmt === false ) {
    sql_error(sqlsrv_errors(), "Error CDPS003" , __LINE__, __FILE__ );
}else{
	$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
	if (trim($row["Id_Unid_Negocio"]) == "CLUB") $Tipo_Cbte = $Tip_Cbte_Cob_Web;
	if (trim($row["Id_Unid_Negocio"]) == "INST") $Tipo_Cbte = $Tipo_Cbte_Web_Inst;
}
// <--


$sql = "EXEC CP_Cbtes_Rec_Generar ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ";
// @pId_Usuario			INT,
// @pId_Cliente			INT,
// @pEmail				VARCHAR(8000),
// @pId_Periodo_Caja	INT,
// @pFecha				DATETIME,
// @pImporte			DECIMAL(16,2), 
// @pId_Tipo_Cbte		CHAR(4),
// @pId_Moneda			CHAR(3),
// @pCotizacion			DECIMAL(9, 4),
// @pLote				VARCHAR(20)
$params = array(0, $data_id_cliente, $data_email, $Per_Caja_Cob_Web, date('Ymd'), 
					$importe_total, $Tipo_Cbte, 'PES', 1, 'RW:' . $data_noperacion);
log_query($sql, $params);
$stmt = sqlsrv_query( $conn, $sql, $params);
log_query($sql, $params);
if( $stmt === false ) {
    sql_error(sqlsrv_errors(), "Error CDPS004" , __LINE__, __FILE__ );
}else{
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			if ( $row['ErrorLine'] ){
				$id_trans = $row['ErrorLine'];
				break;
			}
		}
}

if (!$id_trans){
	$res = array("data" => "", "status" => 400, "message" => "No id_trans - 8635647", "row" => $row);
	echo json_encode($res);
	exit;
}


$item = 1;
foreach ($data_transacciones as $key => $value){
	$sql = "EXEC CP_Cbtes_Rec_Generar_Item ?, ?, ?, ?, ?, ? ";
	// @pId_Trans				INT,
	// @pItem					SMALLINT,
	// @pId_Producto			VARCHAR(14),
	// @pCantidad				DECIMAL(15,5),
	// @pId_Trans_A_Cancelar	INT,
	// @pImporte_A_Cancelar		DECIMAL(16,2)
	$params = array($id_trans, $item, '', 1, $value["id_trans"], $value["importe"]);
	log_query($sql, $params);
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    sql_error(sqlsrv_errors(), "Error CDPS005" , __LINE__, __FILE__ );
	}
	$item++;
}



$sql = "EXEC CP_Cbtes_Rec_Generar_Pago ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
// @pId_Trans				INT,
// @pId_Tipo_Val			CHAR(3),
// @pValor_Nro				INT,	
// @pFecha_Val				DATETIME,
// @pFecha_Emision			DATETIME,
// @pFecha_Acreditacion		DATETIME,
// @pFecha_Vence			DATETIME,
// @pImporte				DECIMAL(12,2),
// @pId_Tarjeta				VARCHAR(10),
// @pTarjeta_Nro			VARCHAR(25),
// @pTarjeta_Vence			DATETIME,
// @pTarjeta_Cod_Seguridad 	VARCHAR(10),
// @pTarjeta_Cod_Autoriz	VARCHAR(10),
// @pTarjeta_Lote			SMALLINT
// @pId_Cta_banco          INT
$params = array($id_trans, 'DB', 1, date('Ymd'), date('Ymd'), date('Ymd'), 
			date('Ymd'), $importe_total, '', '', date('Ymd'), '', '', 0, $Id_Cta_Baco_CWeb );
log_query($sql, $params);
$stmt = sqlsrv_query( $conn, $sql, $params);
log_query($sql, $params);
if( $stmt === false ) {
    sql_error(sqlsrv_errors(), "Error CDPS006" , __LINE__, __FILE__ );
}





$sql = "EXEC CP_Cbtes_Rec_Fin ?";
// @pId_Trans INT
$params = array($id_trans);
$stmt = sqlsrv_query( $conn, $sql, $params);
log_query($sql, $params);
if( $stmt === false ) {
    sql_error(sqlsrv_errors(), "Error CDPS007" , __LINE__, __FILE__ );
}





// Envio de Email
// enviar_mail_smtp_club

$body = "<strong>Nuevo Pago Online - " . $nombre_cliente . "</strong><br>\r\n";
$body .= "<br>\r\n";

$body .= "<u>Información del Socio:</u><br>\r\n";
$body .= "Nombre: " 					. $data_razon_social 				. "<br>\r\n";
$body .= "Nº de Socio: " 				. $data_id_cliente_externo 			. "<br>\r\n";
$body .= "<br>\r\n";
	
if (is_array($data_transacciones)){
	foreach ($data_transacciones as $key => $value){
		$info .= "Transacción: " . $value["id_trans"] . " - Descripción: " . $value["descripcion"] . " - Fecha: " . dbdate($value["fecha"]) . " - Importe: " . convertToCurrency($value["importe"]) . "<br>\r\n";
	}
}
if (is_array($data_productos)){
	$info .= "<br>\r\n";
	foreach ($data_productos as $key => $value){
		$info .= $value["descripcion"] . ": $ " . str_replace(",00", "", number_format($value["importe"], 2, ",", ".")) . "<br>\r\n";
		$info .= "Socio: " . $value["razon_social"] . "<br>\r\n";
		$info .= "Cantidad: " . $value["cantidad"] . " Subtotal: $ " . str_replace(",00", "", number_format(($value["importe"]*$value["cantidad"]), 2, ",", "."))  . "<br>\r\n";
		$info .= "<br>\r\n";
	}
}
	

//Envio de Mail

$body .= "<u>Transacciones:</u><br>\r\n" . $info;
$body .= "<br>\r\n";
$body .= "<u>Información del Pago:</u><br>";
$body .= "Tarjeta: " 					. $data_info_pago["card_brand"] . "<br>\r\n";
$body .= "Código de Autorización: " 	. $data_info_pago["status_details"]["card_authorization_code"] . "<br>\r\n";
$body .= "Nº de Operación: "			. $data_info_pago["site_transaction_id"] . "<br>\r\n";
$body .= "Monto: " 						. convertToCurrency($data_info_pago["amount"] / 100) . "<br>\r\n";
$body .= "Cuotas: " 					. $data_info_pago["installments"] . "<br>\r\n";
$body .= "Fecha: " 						. $data_info_pago["date"] . "<br>\r\n";

$transaccion_resultado = $data_info_pago["status"];
if ($transaccion_resultado == "approved") $transaccion_resultado = "APROBADA";
if ($transaccion_resultado == "rejected") $transaccion_resultado = "RECHAZADA";
$body .= "Resultado: <b>" 				. $transaccion_resultado . "</b><br>\r\n";
$body .= "<br>\r\n<br>\r\n";

$subject = "Nuevo Pago Online - " . $nombre_cliente;
enviar_mail_smtp_club ("no-responder@miclub.info", $data_email, "pagos@miclub.info", $subject, $body, "");




// final de codigo - ok
$res = array("data" => "", "status" => 200, "message" => "");
echo json_encode($res);
exit;



?>