<?

# ==================================================================================
# 
# Funcion: client_password_change
# 
# ==================================================================================
# 
# data (POST)
# 	id_cliente, clave_anterior, clave_nueva
# 
# ==================================================================================

$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

// Parametros >
$data_id_cliente = trim($data["id_cliente"]);
$data_clave_anterior = trim($data["clave_anterior"]);
$data_clave_nueva = trim($data["clave_nueva"]);
// < Parametros

// verifica si el json es valido
if ($jsonerror){
	logError("Invalid JSON", __LINE__ , __FILE__);
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}


// verificar clave nueva.. mas de 3 caract..
if (strlen($data_clave_nueva)<4){
	logError("clave nueva invalida", __LINE__ , __FILE__);
	$res = array("data" => "", "status" => 500, "message" => "Clave nueva inválida.");
	echo json_encode($res);
	exit;
}

// verifica si ingresa el dato id_cliente - proceso principal
if ($data_clave_anterior && $data_clave_nueva){

	$sql = "select Id_Cliente, Clave_Web from Clientes
				where activo=1
				and Id_Cliente = ?
			";
	$params = array($data_id_cliente);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	if( $stmt === false ) {
		sql_error(sqlsrv_errors(), "Error 9102357" , __LINE__, __FILE__ );
	}else{
		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
		if ($row){
			$clave_anterior_db = $row["Clave_Web"];
			if ($clave_anterior_db == $data_clave_anterior){

				$sql = "UPDATE Clientes set Clave_Web = ? WHERE Id_Cliente = ?";
				$params = array($data_clave_nueva, $data_id_cliente);
				$stmt = sqlsrv_query( $conn, $sql, $params);
				if( $stmt === false ) {
					sql_error(sqlsrv_errors(), "Error 00654323" , __LINE__, __FILE__ );
				}else{
					$resp = array("data" => "", "status" => 200, "message" => "");
					echo json_encode($resp);
					exit;
				}

			}else{
				logError("Error clave anterior 5683476", __LINE__ , __FILE__);
				$res = array("data" => "", "status" => 400, "message" => "Error clave anterior 5683476");
				echo json_encode($res);
				exit;
			}
		}

	}

}

// final de codigo - error
logError("Incorrect Data", __LINE__ , __FILE__);
$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
echo json_encode($res);
exit;



?>