<?

/*     clever-autodoc
<clever-autodoc>
	<file name="index.php">
		<name>index.php</name>
		<last_update>03/12/2019 10:27Hs</last_update>
		<updates>
			<item>
				<date>03/12/2019 10:27Hs</date>
				<description>Se agrega el include_once de sca_api_megatlon</description>
			</item>
			<item>
				<date>25/02/2019 15:24Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>ApiTest</name>
				<description>Prueba la API y devuelve el primer registro de la tabla Empresas_Unid_Negocios</description>
			</item>
			<item>
				<name>setTempUser</name>
				<description>Inserta en Clientes_Temp un nuevo registro</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/

/*      // IPs Habilitados (array)         // BLOQUEO DE IPS NO REGISTRADAS

	// IPs Habilitados (array)
	$lista_ips[] = "127.0.0.1";		// local
	$lista_ips[] = "10.10.10.10";
	$lista_ips[] = "::1";


	// BLOQUEO DE IPS NO REGISTRADAS
	$ip = $_SERVER["REMOTE_ADDR"];
	if (!in_array($ip, $lista_ips)) exit;
	// -----------------------------

*/


# ==================================================================================
// -- FUNCIONES
# ==================================================================================
/*

- ApiTest						Prueba de funcionamiento: data JSON / conexion a base de datos



*/
$debug = "";	
if(isset($_POST["debug"])) {
	$debug = $_POST["debug"];
}else{
	if(isset($_GET["debug"])) {
		$debug = $_GET["debug"];	
	}	
}


/*Includes INICIO*/
include_once "functions.php";
logDebug($debug,"", __LINE__, __FILE__);
include_once "api_config.php";
logDebug($debug,"", __LINE__, __FILE__);




// Flag para enviar datos por GET (GET -> POST)
if ($_GET["setPost"]==1){
	$_POST = $_GET;
	logDebug($debug,"$_POST = $_GET", __LINE__, __FILE__);
	//print_r($_POST);
	//exit;
}


/*Se verifica si se envian datos por un POST INICIO*/
if (!$_POST){
	logError("No se envio datos por POST", __LINE__ , __FILE__);
	$res = array("data" => "", "status" => 406, "message" => "No se envio datos por POST");
	echo json_encode($res);
	exit;
}
logDebug($debug,"Despues de if (!$_POST)", __LINE__, __FILE__);
/*Se verifica si se envian datos por un POST FIN*/

/*Verifica si el Token enviado por POST es valido. INCIO*/
$token = "";
if(isset($_POST["token"])) { $token = $_POST["token"];}
if($token != $cliente_token)
{
	logError("Token Invalido", __LINE__ , __FILE__);
	$res = array("data" => "", "status" => 400, "message" => "Token Invalido");
	echo json_encode($res);
	exit;
}
logDebug($debug,"Despues de if($token != $cliente_token)", __LINE__, __FILE__);

/*Tables Core*/

if ($_POST["api_test"]==1)					{ include_once __DIR__ ."/core/api_test.php"; }
if ($_POST["sql_query"]==1)					{ include_once __DIR__ ."/core/sql_query.php"; }

/*Tables Module*/


if ($_POST["client_login"]==1)				{ include_once __DIR__ ."/tables/client_login.php"; }
if ($_POST["client_password_change"]==1)	{ include_once __DIR__ ."/tables/client_password_change.php"; }
if ($_POST["client_register"]==1)			{ include_once __DIR__ ."/tables/client_register.php"; }



if ($_POST["client_fetch"]==1)				{ include_once __DIR__ ."/tables/client_fetch.php"; }
if ($_POST["client_update_web"]==1)			{ include_once __DIR__ ."/tables/client_update_web.php"; }
if ($_POST["client_temp_fetch"]==1)			{ include_once __DIR__ ."/tables/client_temp_fetch.php"; }



if ($_POST["contracts"]==1)					{ include_once __DIR__ ."/tables/contracts.php"; }
if ($_POST["contracts_card_update"]==1)		{ include_once __DIR__ ."/tables/contracts_card_update.php"; }

if ($_POST["tab_countries"]==1)				{ include_once __DIR__ ."/tables/tab_countries.php"; }
if ($_POST["tab_provinces"]==1)				{ include_once __DIR__ ."/tables/tab_provinces.php"; }
if ($_POST["tab_localities"]==1)			{ include_once __DIR__ ."/tables/tab_localities.php"; }

/*Tables Module*/
if ($_POST["client_debt"]==1)				{ include_once __DIR__ ."/sales/client_debt.php"; }



/*Treasury Module*/

if ($_POST["credit_cards"]==1)				{ include_once __DIR__ ."/treasury/credit_cards.php"; }
if ($_POST["credit_card_validate"]==1)		{ include_once __DIR__ ."/treasury/credit_card_validate.php"; }
if ($_POST["setPayment"]==1)				{ include_once __DIR__ ."/treasury/setPayment.php"; }

/*Crm Module*/

if ($_POST["crm_contacts"]==1)				{ include_once __DIR__ ."/crm/crm_contacts.php"; }
if ($_POST["crm_contacts_insert"]==1)		{ include_once __DIR__ ."/crm/crm_contacts_insert.php"; }
if ($_POST["crm_cont_motives"]==1)			{ include_once __DIR__ ."/crm/crm_cont_motives.php"; }
if ($_POST["crm_cont_submotives"]==1)		{ include_once __DIR__ ."/crm/crm_cont_submotives.php"; }
if ($_POST["crm_cont_objects"]==1)			{ include_once __DIR__ ."/crm/crm_cont_objects.php"; }

if ($_POST["shifts_client"]==1)				{ include_once __DIR__ ."/crm/shifts_client.php"; }
if ($_POST["shifts_types_client"]==1)		{ include_once __DIR__ ."/crm/shifts_types_client.php"; }
if ($_POST["shifts_month"]==1)				{ include_once __DIR__ ."/crm/shifts_month.php"; }

if ($_POST["shift_client_save"]==1)			{ include_once __DIR__ ."/crm/shift_client_save.php"; }
if ($_POST["shift_client_cancel"]==1)		{ include_once __DIR__ ."/crm/shift_client_cancel.php"; }
if ($_POST["shift_type_save"]==1)			{ include_once __DIR__ ."/crm/shift_type_save.php"; }


	
include_once "api_login.php";

include_once "api_datos.php";
include_once "api_d_isis.php";

include_once "api_ventas.php";
include_once "api_teso.php";
include_once "api_fser.php";


include_once "api_ptos.php";
include_once "api_ptossrv.php";

include_once "api_tbl_srv.php";
include_once "api_tablas.php";

include_once "sca/api_sca.php";
include_once "sca/api_sca_api_megatlon.php";

include_once "api_crm.php";
include_once "api_turnos.php";

/*Includes FIN*/







# ==================================================================================
// -- TEST
# ==================================================================================

//$_POST["ApiTest"] = 1;
//$_POST["data"] = json_encode(array("id_cliente" => 1));
//echo $_POST["data"]; exit;



# ==================================================================================


//print_r($_GET);


/*Verifica si el Token enviado por POST es valido. FIN*/

/*
<clever-autodoc>
	<function name="ApiTest">
		<name>ApiTest</name>
		<description>Prueba la API y devuelve el primer registro de la tabla Empresas_Unid_Negocios</description>
		<parameters>
			<item>
				<name>pValor</name>
				<type>INT</type>
				<description>Cualquier valor distinto de cero.</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Unid_Negocio</name>
					<type>CHAR(10)</type>
					<description>Codigo de la Unidad de Negocio</description>
				</item>
				<item>
					<name>Descripcion</name>
					<type>VARCHAR(65)</type>
					<description>Nombre de la Unidad de Negocio</description>
				</item>
				<item>
					<name>Encabezado_Rpt</name>
					<type>VARCHAR(100)</type>
					<description>Encabezado para los reportes (Generalmente aqui aparece el nombre de la empresa)</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*ApiTest INICIO*/



















function GetLastResultNumeric($stmt){
	$finalResult = false;
	do {
		$finalResult = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC);
		// Use $stmt, e.g. store result in $finalResult to return as the final result 
		// useful functions: sqlsrv_num_fields, sqlsrv_has_rows, sqlsrv_rows_affected, sqlsrv_fetch_..., etc. 
	} while ( sqlsrv_next_result($stmt) ) ;
	return $finalResult; 
}

function GetLastResultAssoc($stmt){
	$finalResult = false;
	do {
		$finalResult = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
		// Use $stmt, e.g. store result in $finalResult to return as the final result 
		// useful functions: sqlsrv_num_fields, sqlsrv_has_rows, sqlsrv_rows_affected, sqlsrv_fetch_..., etc. 
	} while ( sqlsrv_next_result($stmt) ) ;
	return $finalResult; 
}



function onlyNumbers($ii){
	$ii = trim($ii);
	$ii = str_replace(".", "", $ii);
	$ii = str_replace(",", "", $ii);
	$ii = str_replace("-", "", $ii);
	$ii = str_replace("/", "", $ii);
	$ii = str_replace("\\", "", $ii);
	$ii = str_replace("|", "", $ii);
	if (preg_match ("/^([0-9]+)$/", $ii)) {
	     return true;
	} else {
	     return false;
	}
}




function log_query($query, $params){

	$enter = "\r\n\r\n";

	$v .= "DATE: " 		. date("Y-m-d H:i:s") 				. $enter;
	$v .= "QUERY: " 	. $query					 		. $enter;
	$v .= "PARAMS: " 	. var_export($params, true) 		. $enter;
	foreach ($params as $key => $value){
		$query = preg_replace("/\?/", "'" . $value . "'", $query, 1);
	}
	$v .= "FULL: " . $query . $enter;

	if (!is_dir("log/")){ @mkdir("log/"); chmod("log/", 0700); }
  	$handle = fopen("log/query_" . date("Ymd") . ".txt", "a");
  	if (fwrite($handle, $v) === false) {
  		//echo "Cannot write to text file. <br />";
  	}
  	fclose($handle);


}




?>