<?

# ==================================================================================
# 
# Confirma un turno
# shift_client_save=1
# 
# ==================================================================================
# 
# data (POST)
# 	{id_cliente, id_turno_tipo, descripcion, anio, mes, dia, hora, minutos, email}
# 
# ==================================================================================


$data = json_decode($_POST["data"], true);
$jsonerror = json_last_error();

$data_id_cliente = $data["id_cliente"];
$data_id_turno_tipo = $data["id_turno_tipo"];
$data_descripcion = trim($data["descripcion"]);

$data_anio = (int)$data["anio"];
$data_mes = (int)$data["mes"];
$data_dia = (int)$data["dia"];
$data_hora = (int)$data["hora"];
$data_minutos = (int)$data["minutos"];

$data_email = trim($data["email"]);

// verifica si el json es valido
if ($jsonerror){
	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	echo json_encode($res);
	exit;
}

if ($data_id_cliente && $data_id_turno_tipo && $data_anio && $data_mes && $data_dia){

	// VERIFICO SI YA ESTA TOMADO...
	$cant = 0;
	$sql = "SELECT * FROM CRM_Turnos WHERE YEAR(Fecha)=? AND MONTH(Fecha)=? AND DAY(Fecha)=? AND DATEPART(hour, Fecha)=? AND DATEPART(minute, Fecha)=? AND Activo=1";
	$params = array($data_anio, $data_mes, $data_dia, $data_hora, $data_minutos);
	$stmt = sqlsrv_query( $conn, $sql, $params);
	if( $stmt === false ) {
  	    sql_error(sqlsrv_errors(), "ERROR: CSCS 00100" , __LINE__, __FILE__ );
	}else{
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			$cant++;
		}
		// SI NO ESTA TOMADO LO INGRESO A LA DB
		if ($cant==0){
			$fecha = $data_anio . str_pad($data_mes, 2, "0", STR_PAD_LEFT) . str_pad($data_dia, 2, "0", STR_PAD_LEFT) . " " . str_pad($data_hora, 2, "0", STR_PAD_LEFT) . ":" . str_pad($data_minutos, 2, "0", STR_PAD_LEFT);
			$sql = "INSERT INTO CRM_Turnos (Id_Cliente, Id_Turno_Tipo, Fecha, Descripcion, Activo) values (?, ?, ?, ?, 1)";
			$params = array($data_id_cliente, $data_id_turno_tipo, $fecha, $data_descripcion);
			$stmt = sqlsrv_query( $conn, $sql, $params);
			if( $stmt === false ) {
		  	    sql_error(sqlsrv_errors(), "ERROR: CSSM 00200" , __LINE__, __FILE__ );
			}else{
			  	$res = array("data" => "", "status" => 200, "message" => "");
			  	echo json_encode($res);
			  	exit;					
			}
		}else{
			$res = array("data" => "", "status" => 401, "message" => "Turno no disponible");
		  	echo json_encode($res);
		  	exit;
		}
	}
}

// final de codigo - error
$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
echo json_encode($res);
exit;




?>