<?



/* clever-autodoc
<clever-autodoc>
	<file name="ventas.php">
		<name>ventas.php</name>
		<last_update>13/06/2019 17:19Hs</last_update>
		<updates>
			<item>
				<date>13/06/2019 17:19Hs</date>
				<description>Se agregó el método: CP_Cbtes_Rem_Generar</description>
			</item>
			<item>
				<date>22/02/2019 15:54Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getBrowsePedidos</name>
				<description>Llama al Stored Procedure: CP_Browse_Cbtes_Pedidos para retornar el Browse del Administrador de Pedidos</description>
			</item>
			<item>
				<name>getBrowseClientesCtaCte</name>
				<description>Llama al Stored Procedure: CP_Browse_Clientes_CtaCte para retornar el Browse del Administrador de Pedidos</description>
			</item>
			<item>
				<name>CP_Cbtes_Ped_Generar</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Ped_Generar para cargar la cabecera de un Comprobante Tipo Pedido</description>
			</item>
			<item>
				<name>CP_Cbtes_Ped_Generar_Item</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Ped_Generar_Item para cargar los items de un Comprobante Tipo Pedido</description>
			</item>
			<item>
				<name>CP_Cbtes_Ped_Fin</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Ped_Fin para finalizar la carga de un Comprobante Tipo Pedido</description>
			</item>
			<item>
				<name>CP_Cbtes_Rem_Generar</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Rem_Generar para cargar la cabecera de un Comprobante Tipo Remito</description>
			</item>
			<item>
				<name>CP_Cbtes_Rem_Generar_Item</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Rem_Generar_Item para cargar los items de un Comprobante Tipo Remito</description>
			</item>
			<item>
				<name>CP_Cbtes_Rem_Fin</name>
				<description>Llama al Stored Procedure: CP_Cbtes_Rem_Fin para finalizar la carga de un Comprobante Tipo Remito</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/










/* clever-autodoc
<clever-autodoc>
	<function name="getBrowsePedidos">
		<name>getBrowsePedidos</name>
		<description>Llama al Stored Procedure: CP_Browse_Cbtes_Pedidos para retornar el Browse del Administrador de Pedidos</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Codigo Id_Cliente que se quiere filtrar los cbtes de pedido</description>
			</item>
			<item>
				<name>pId_Estado_Cbte</name>
				<type>SMALLINT</type>
				<description>Id_Estado_Cbte que se quiere filtrar los cbtes de pedidos</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>			
				<item>
					<name>Comprobante</name>
					<type>VARCHAR(50)</type>
					<description> Nro. de Comprobante (Formato completo)</description>
				</item>
				<item>
					<name>UN</name>
					<type>CHAR(10)</type>
					<description>Unidad de Negocio</description>
				</item>
				<item>
					<name>Fecha</name>
					<type>DATE</type>
					<description>Fecha del Comprobante</description>
				</item>
				<item>
					<name>Cliente</name>
					<type>INT</type>
					<description>Id_cliente</description>
				</item>
				<item>
					<name>Razon_Social</name>
					<type>VARCHAR(100)</type>
					<description>Apellido y Nombre del Cliente al que se le hizo el comprobante</description>
				</item>
				<item>
					<name>Suc</name>
					<type>SMALLINT</type>
					<description>Sucursal (Id_Sucursal) del Comprobante</description>
				</item>
				<item>
					<name>F_Estimada</name>
					<type>DATE</type>
					<description>Fecha Estimade del Pedido</description>
				</item>
				<item>
					<name>DP_1</name>
					<type>VARCHAR(100)</type>
					<description>Datos Particulares 1</description>
				</item>
				<item>
					<name>DP_2</name>
					<type>VARCHAR(100)</type>
					<description>Datos Particulares 2</description>
				</item>
				<item>
					<name>O_Compra</name>
					<type>VARCHAR(25)</type>
					<description>Orden de compra correspondiente al comprobante de pedido</description>
				</item>
				<item>
					<name>Id_Estado_Cbte</name>
					<type>SMALLINT</type>
					<description>Id_Estado del Comprobante</description>
				</item>
				<item>
					<name>Estado</name>
					<type>VARCHAR(35)</type>
					<description>Estado del Pedido</description>
				</item>
				<item>
					<name>Importe</name>
					<type>DECIMAL(12,2)</type>
					<description>Importe total del comprobante</description>
				</item>
				<item>
					<name>Trans</name>
					<type>INT</type>
					<description>Codigo de Transaccion</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getBrowsePedidos INICIO*/
if ($_POST["getBrowsePedidos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getBrowsePedidos: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Cliente = $data["pId_Cliente"];
	$pId_Estado_Cbte = $data["pId_Estado_Cbte"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente && $pId_Estado_Cbte != ''){
		
		$sql = "EXEC CP_Browse_Cbtes_Pedidos ?, ?";
		$params = array($pId_Cliente, $pId_Estado_Cbte);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getBrowsePedidos: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getBrowsePedidos: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getBrowsePedidos: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getBrowsePedidos FIN*/



/* clever-autodoc
<clever-autodoc>
	<function name="getBrowseClientesCtaCte">
		<name>getBrowseClientesCtaCte</name>
		<description>Llama al Stored Procedure: CP_Browse_Clientes_CtaCte para retornar el Browse del Administrador de Pedidos</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Codigo Id_Cliente que se quiere filtrar los cbtes de la cuenta corriente</description>
			</item>
			<item>
				<name>pId_Estado_Cbte</name>
				<type>SMALLINT</type>
				<description>Id_Estado_Cbte que se quiere filtrar los cbtes de la cuenta corriente</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>			
				<item>
					<name>Vencimiento</name>
					<type>DATE</type>
					<description>Fecha de Vencimiento del Cbte</description>
				</item>
				<item>
					<name>Fecha</name>
					<type>DATE</type>
					<description>Fecha del cbte.</description>
				</item>
				<item>
					<name>Descripcion</name>
					<type>VARCHAR(100)</type>
					<description>Tipo y Nro. de Cbte</description>
				</item>
				<item>
					<name>Cliente</name>
					<type>INT</type>
					<description>Codigo de Cliente</description>
				</item>
				<item>
					<name>Fec_Pres_Deb</name>
					<type>DATE</type>
					<description>Fecha de Presentación del Debito</description>
				</item>
				<item>
					<name>Cuota</name>
					<type>SMALLINT</type>
					<description>Nro de Cuota</description>
				</item>
				<item>
					<name>Mon</name>
					<type>CHAR(3)</type>
					<description>Tipo de Moneda</description>
				</item>
				<item>
					<name>Cotiz</name>
					<type>DECIMAL(12,4)</type>
					<description>Monto de cotización</description>
				</item>
				<item>
					<name>Debe</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Debe</description>
				</item>
				<item>
					<name>Haber</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Haber</description>
				</item>
				<item>
					<name>Saldo</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Saldo restante</description>
				</item>
				<item>
					<name>Moneda_Corriente_Acumulado</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto en moneda corriente</description>
				</item>
				<item>
					<name>Debe_Mon_Extr</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Debe en moneda extranjera</description>
				</item>
				<item>
					<name>Haber_Mon_Extr</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Haber en moneda extranjera</description>
				</item>
				<item>
					<name>Saldo_Mon_Extr</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Saldo en moneda extranjera</description>
				</item>
				<item>
					<name>Moneda_Extranjera_Acumulado</name>
					<type>DECIMAL(12,2)</type>
					<description>Monto del Acumulado en moneda extranjera</description>
				</item>
				<item>
					<name>F_Ult_Contac</name>
					<type>DATE</type>
					<description>Fecha de Ultimo Contacto (CRM)</description>
				</item>
				<item>
					<name>Observacion</name>
					<type>VARCHAR(200)</type>
					<description>Observacion del comprobante</description>
				</item>
				<item>
					<name>Transaccion</name>
					<type>INT</type>
					<description>Nro de Transaccion</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getBrowseClientesCtaCte INICIO*/
if ($_POST["getBrowseClientesCtaCte"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getBrowseClientesCtaCte: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pId_Cliente = $data["pId_Cliente"];
	$pId_Estado_Cbte = $data["pId_Estado_Cbte"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente && $pId_Estado_Cbte){
		
		$sql = "EXEC CP_Browse_Clientes_CtaCte ?, ?";
		$params = array($pId_Cliente, $pId_Estado_Cbte);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getBrowseClientesCtaCte: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getBrowseClientesCtaCte: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getBrowseClientesCtaCte: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getBrowseClientesCtaCte FIN*/



/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Ped_Generar">
		<name>CP_Cbtes_Ped_Generar</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Ped_Generar para cargar la cabecera de un Comprobante Tipo Pedido</description>
		<parameters>
			<item>
				<name>pId_Usuario</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Tipo_Cbte</name>
				<type>CHAR(4)</type>
				<description></description>
			</item>		
			<item>
				<name>pFecha</name>
				<type>DATETIME</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_Venc</name>
				<type>DATETIME</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_Estimada</name>
				<type>DATETIME</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Vendedor</name>
				<type>VARCHAR(10)</type>
				<description></description>
			</item>
			<item>
				<name>pCbte_Nro_Externo</name>
				<type>VARCHAR(25)</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Cond_Pago</name>
				<type>SMALLINT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cond_Vta</name>
				<type>CHAR(10)</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Moneda</name>
				<type>CHAR(3)</type>
				<description></description>
			</item>
			<item>
				<name>pCotizacion</name>
				<type>DECIMAL(9,4)</type>
				<description></description>
			</item>
			<item>
				<name>pPorc_Bonificacion</name>
				<type>DECIMAL(5,2)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Camp</name>
				<type>SMALLINT</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Centro_Costo</name>
				<type>CHAR(10)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Lista</name>
				<type>SMALLINT</type>
				<description></description>
			</item>		
			<item>
				<name>pEmail</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Puerto</name>
				<type>CHAR(3)</type>
				<description></description>
			</item>		
			<item>
				<name>pNota_Part1</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pNota_Part2</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pObservacion</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pNro_Perm_Embarque</name>
				<type>VARCHAR(20)</type>
				<description></description>
			</item>		
			<item>
				<name>pPersona_Recibe</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pLote</name>
				<type>VARCHAR(20)</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Id_Trans</name>
					<type>INT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Ped_Generar INICIO*/
if ($_POST["CP_Cbtes_Ped_Generar"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Ped_Generar: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Usuario	 	= $data["pId_Usuario"];
	$pId_Tipo_Cbte	 	= $data["pId_Tipo_Cbte"];
	$pFecha	 			= $data["pFecha"];
	$pId_Cliente	 	= $data["pId_Cliente"];
	$pFecha_Venc	 	= $data["pFecha_Venc"];
	$pFecha_Estimada	= $data["pFecha_Estimada"];
	$pId_Vendedor	 	= $data["pId_Vendedor"];
	$pCbte_Nro_Externo	= $data["pCbte_Nro_Externo"];
	$pId_Cond_Pago	 	= $data["pId_Cond_Pago"];
	$pId_Cond_Vta	 	= $data["pId_Cond_Vta"];
	$pId_Moneda	 		= $data["pId_Moneda"];
	$pCotizacion	 	= $data["pCotizacion"];
	$pPorc_Bonificacion	= $data["pPorc_Bonificacion"];
	$pId_Camp	 		= $data["pId_Camp"];
	$pId_Centro_Costo	= $data["pId_Centro_Costo"];
	$pId_Lista	 		= $data["pId_Lista"];
	$pEmail	 			= $data["pEmail"];
	$pId_Puerto	 		= $data["pId_Puerto"];
	$pNota_Part1	 	= $data["pNota_Part1"];
	$pNota_Part2	 	= $data["pNota_Part2"];
	$pObservacion	 	= $data["pObservacion"];
	$pNro_Perm_Embarque	= $data["pNro_Perm_Embarque"];
	$pPersona_Recibe	= $data["pPersona_Recibe"];
	$pLote	 			= $data["pLote"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Usuario && $pId_Tipo_Cbte && $pFecha && $pId_Cliente && $pFecha_Venc && $pFecha_Estimada && $pId_Vendedor && $pId_Cond_Pago && $pId_Moneda && $pCotizacion && $pPorc_Bonificacion && $pId_Lista && $pEmail && $pNota_Part1 && $pNota_Part2 && $pObservacion && $pPersona_Recibe && $pLote){
		
		$sql = "EXEC CP_Cbtes_Ped_Generar ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pId_Usuario, $pId_Tipo_Cbte, $pFecha, $pId_Cliente, $pFecha_Venc, $pFecha_Estimada, $pId_Vendedor, $pCbte_Nro_Externo, $pId_Cond_Pago, $pId_Cond_Vta, $pId_Moneda, $pCotizacion, $pPorc_Bonificacion, $pId_Camp, $pId_Centro_Costo, $pId_Lista, $pEmail, $pId_Puerto, $pNota_Part1, $pNota_Part2, $pObservacion, $pNro_Perm_Embarque, $pPersona_Recibe, $pLote);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Ped_Generar: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Ped_Generar: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Ped_Generar: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Ped_Generar FIN*/




/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Ped_Generar_Item">
		<name>CP_Cbtes_Ped_Generar_Item</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Ped_Generar_Item para cargar los items de un Comprobante Tipo Pedido</description>
		<parameters>
			<item>
				<name>pId_Trans</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Producto</name>
				<type>VARCHAR(14)</type>
				<description></description>
			</item>		
			<item>
				<name>pCantidad</name>
				<type>DECIMAL(15,5)</type>
				<description></description>
			</item>
			<item>
				<name>pObservacion</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_QA</name>
				<type>DATETIME</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_Venc</name>
				<type>DATETIME</type>
				<description></description>
			</item>		
			<item>
				<name>pPrecio_Grav</name>
				<type>DECIMAL(15,5)</type>
				<description></description>
			</item>
			<item>
				<name>pPorc_Iva </name>
				<type>DECIMAL(5,2)</type>
				<description></description>
			</item>		
			<item>
				<name>pBonif</name>
				<type>DECIMAL(5,2)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Item</name>
					<type>SMALLINT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Ped_Generar_Item INICIO*/
if ($_POST["CP_Cbtes_Ped_Generar_Item"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Ped_Generar_Item: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Trans	 	= $data["pId_Trans"];
	$pId_Producto	= $data["pId_Producto"];
	$pCantidad	 	= $data["pCantidad"];
	$pObservacion	= $data["pObservacion"];
	$pFecha_QA	 	= $data["pFecha_QA"];
	$pFecha_Venc	= $data["pFecha_Venc"];
	$pPrecio_Grav	= $data["pPrecio_Grav"];
	$pPorc_Iva		= $data["pPorc_Iva"];
	$pBonif	 		= $data["pBonif"];
	$pId_Cliente	= $data["pId_Cliente"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Trans && $pId_Producto && $pCantidad && $pObservacion && $pFecha_QA && $pFecha_Venc && $pPrecio_Grav && $pPorc_Iva && $pId_Cliente){
		
		$sql = "EXEC CP_Cbtes_Ped_Generar_Item ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pId_Trans, $pId_Producto, $pCantidad, $pObservacion, $pFecha_QA, $pFecha_Venc, $pPrecio_Grav, $pPorc_Iva, $pBonif, $pId_Cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Ped_Generar_Item: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Ped_Generar_Item: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Ped_Generar_Item: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Ped_Generar_Item FIN*/



/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Ped_Fin">
		<name>CP_Cbtes_Ped_Fin</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Ped_Fin para cerrar el Comprobante Tipo Pedido</description>
		<parameters>
			<item>
				<name>pId_Trans</name>
				<type>INT</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Id_Trans</name>
					<type>INT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Ped_Fin INICIO*/
if ($_POST["CP_Cbtes_Ped_Fin"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Ped_Fin: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Trans	 	= $data["pId_Trans"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Trans){
		
		$sql = "EXEC CP_Cbtes_Ped_Fin ?";
		$params = array($pId_Trans);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Ped_Fin: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Ped_Fin: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Ped_Fin: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Ped_Fin FIN*/


/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Rem_Generar">
		<name>CP_Cbtes_Rem_Generar</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Rem_Generar para cargar la cabecera de un Comprobante Tipo Remito</description>
		<parameters>
			<item>
				<name>pId_Usuario</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Tipo_Cbte</name>
				<type>CHAR(4)</type>
				<description></description>
			</item>		
			<item>
				<name>pFecha</name>
				<type>DATETIME</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_Estimada</name>
				<type>DATETIME</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Vendedor</name>
				<type>VARCHAR(10)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cond_Pago</name>
				<type>SMALLINT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cond_Vta</name>
				<type>CHAR(10)</type>
				<description></description>
			</item>		
			<item>
				<name>pId_Centro_Costo</name>
				<type>CHAR(10)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Lista</name>
				<type>SMALLINT</type>
				<description></description>
			</item>		
			<item>
				<name>pEmail</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Puerto</name>
				<type>CHAR(3)</type>
				<description></description>
			</item>		
			<item>
				<name>pNota_Part1</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pNota_Part2</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pObservacion</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pNro_Perm_Embarque</name>
				<type>VARCHAR(20)</type>
				<description></description>
			</item>		
			<item>
				<name>pPersona_Recibe</name>
				<type>VARCHAR(100)</type>
				<description></description>
			</item>
			<item>
				<name>pLote</name>
				<type>VARCHAR(20)</type>
				<description></description>
			</item>
			<item>
				<name>pPedido_Nro</name>
				<type>VARCHAR(25)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Transportista</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pDir_Entrega</name>
				<type>VARCHAR(255)</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Id_Trans</name>
					<type>INT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Rem_Generar INICIO*/
if ($_POST["CP_Cbtes_Rem_Generar"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Rem_Generar: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Usuario	 	= $data["pId_Usuario"];
	$pId_Tipo_Cbte	 	= $data["pId_Tipo_Cbte"];
	$pFecha	 			= $data["pFecha"];
	$pId_Cliente	 	= $data["pId_Cliente"];	
	$pFecha_Estimada	= $data["pFecha_Estimada"];
	$pId_Vendedor	 	= $data["pId_Vendedor"];
	$pId_Cond_Pago	 	= $data["pId_Cond_Pago"];
	$pId_Cond_Vta	 	= $data["pId_Cond_Vta"];
	$pId_Centro_Costo	= $data["pId_Centro_Costo"];
	$pId_Lista	 		= $data["pId_Lista"];
	$pEmail	 			= $data["pEmail"];
	$pId_Puerto	 		= $data["pId_Puerto"];
	$pNota_Part1	 	= $data["pNota_Part1"];
	$pNota_Part2	 	= $data["pNota_Part2"];
	$pObservacion	 	= $data["pObservacion"];
	$pNro_Perm_Embarque	= $data["pNro_Perm_Embarque"];
	$pPersona_Recibe	= $data["pPersona_Recibe"];
	$pLote	 			= $data["pLote"];
	$pPedido_Nro	 	= $data["pPedido_Nro"];
	$pId_Transportista	= $data["pId_Transportista"];
	$pDir_Entrega	 	= $data["pDir_Entrega"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Usuario && $pId_Tipo_Cbte && $pFecha && $pId_Cliente && $pFecha_Estimada && $pId_Vendedor && $pId_Cond_Pago && $pId_Lista && $pEmail && $pNota_Part1 && $pNota_Part2 && $pObservacion && $pPersona_Recibe && $pLote){
		
		$sql = "EXEC CP_Cbtes_Rem_Generar ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pId_Usuario, $pId_Tipo_Cbte, $pFecha, $pId_Cliente, $pFecha_Estimada, $pId_Vendedor, $pId_Cond_Pago, $pId_Cond_Vta, $pId_Centro_Costo, $pId_Lista, $pEmail, $pId_Puerto, $pNota_Part1, $pNota_Part2, $pObservacion, $pNro_Perm_Embarque, $pPersona_Recibe, $pLote, $pPedido_Nro, $pId_Transportista, $pDir_Entrega);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Rem_Generar: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Rem_Generar: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Rem_Generar: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Rem_Generar FIN*/


/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Rem_Generar_Item">
		<name>CP_Cbtes_Rem_Generar_Item</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Rem_Generar_Item para cargar los items de un Comprobante Tipo Remito</description>
		<parameters>
			<item>
				<name>pId_Trans</name>
				<type>INT</type>
				<description></description>
			</item>
			<item>
				<name>pId_Producto</name>
				<type>VARCHAR(14)</type>
				<description></description>
			</item>		
			<item>
				<name>pCantidad</name>
				<type>DECIMAL(15,5)</type>
				<description></description>
			</item>
			<item>
				<name>pObservacion</name>
				<type>VARCHAR(8000)</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_QA</name>
				<type>DATETIME</type>
				<description></description>
			</item>
			<item>
				<name>pFecha_Venc</name>
				<type>DATETIME</type>
				<description></description>
			</item>		
			<item>
				<name>pPrecio_Grav</name>
				<type>DECIMAL(15,5)</type>
				<description></description>
			</item>
			<item>
				<name>pPorc_Iva </name>
				<type>DECIMAL(5,2)</type>
				<description></description>
			</item>		
			<item>
				<name>pBonif</name>
				<type>DECIMAL(5,2)</type>
				<description></description>
			</item>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Item</name>
					<type>SMALLINT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Rem_Generar_Item INICIO*/
if ($_POST["CP_Cbtes_Rem_Generar_Item"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Rem_Generar_Item: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Trans	 	= $data["pId_Trans"];
	$pId_Producto	= $data["pId_Producto"];
	$pCantidad	 	= $data["pCantidad"];
	$pObservacion	= $data["pObservacion"];
	$pFecha_QA	 	= $data["pFecha_QA"];
	$pFecha_Venc	= $data["pFecha_Venc"];
	$pPrecio_Grav	= $data["pPrecio_Grav"];
	$pPorc_Iva		= $data["pPorc_Iva"];
	$pBonif	 		= $data["pBonif"];
	$pId_Cliente	= $data["pId_Cliente"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Trans && $pId_Producto && $pCantidad && $pObservacion && $pFecha_QA && $pFecha_Venc && $pPrecio_Grav && $pPorc_Iva && $pId_Cliente){
		
		$sql = "EXEC CP_Cbtes_Rem_Generar_Item ?, ?, ?, ?, ?, ?, ?, ?, ?, ?";
		$params = array($pId_Trans, $pId_Producto, $pCantidad, $pObservacion, $pFecha_QA, $pFecha_Venc, $pPrecio_Grav, $pPorc_Iva, $pBonif, $pId_Cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Rem_Generar_Item: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Rem_Generar_Item: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Rem_Generar_Item: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Rem_Generar_Item FIN*/



/* clever-autodoc
<clever-autodoc>
	<function name="CP_Cbtes_Rem_Fin">
		<name>CP_Cbtes_Rem_Fin</name>
		<description>Llama al Stored Procedure: CP_Cbtes_Rem_Fin para cerrar el Comprobante Tipo Remito</description>
		<parameters>
			<item>
				<name>pId_Trans</name>
				<type>INT</type>
				<description></description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>ErrorNumber</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorSeverity</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorState</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorProcedure</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorLine</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>ErrorMessage</name>
					<type>INT</type>
					<description></description>
				</item>
				<item>
					<name>Id_Trans</name>
					<type>INT</type>
					<description></description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*CP_Cbtes_Rem_Fin INICIO*/
if ($_POST["CP_Cbtes_Rem_Fin"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("CP_Cbtes_Rem_Fin: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Trans	 	= $data["pId_Trans"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Trans){
		
		$sql = "EXEC CP_Cbtes_Rem_Fin ?";
		$params = array($pId_Trans);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("CP_Cbtes_Rem_Fin: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("CP_Cbtes_Rem_Fin: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("CP_Cbtes_Rem_Fin: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*CP_Cbtes_Rem_Fin FIN*/

?>