<?

/*

TESO:
- setPaymentAbonos


- setTempUserPaymentSPS 		ingreso la info de pago / verificar el resultado de la operacion (decidir)
- setTempUserPayment 			ingreso la info de pago al usuario temp



- setPaymentProd				ingreso la info de pago compra productos


- tarjeta_validar				Valida el nro de tarjeta o cbu

- Valores_Tarjetas_Cred			select * from Valores_Tarjetas_Cred
- Valores_Monedas


*/



# ==================================================================================
# 
# Ingreso de Pagos Abonos
# setPaymentAbonos=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"} toda la info de decidir
# 
# ==================================================================================

if ($_POST["setPaymentAbonos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	$data_id_cliente = $data["id_cliente"];
	$data_noperacion = $data["noperacion"];
	$data_productos = $data["productos"];
	$data_adicionales = $data["adicionales"];	// socios adicionales para los packs 4x3 etc
	//$data_adicionales_codigo = $data["socios_adicionales_codigo"];	// socios adicionales para los packs 4x3 etc		no -> estan en data_productos
	if ($data_productos[0]["socios_adicionales_codigo"]) $data_adicionales_codigo = $data_productos[0]["socios_adicionales_codigo"];
	
	$importe_total = 0;
	foreach($data_productos as $key => $value){
		$importe_total += $value["importe"];
	}
	
	if (!$importe_total){
  		logError("Error sql 754984", __LINE__);
		$res = array("data" => "", "status" => 400, "message" => "Error 754984 - Importe total $importe_total");
  		echo json_encode($res);
  		exit;
	}
	
	$observacion = "";
	if (is_array($data_adicionales)){
		foreach ($data_adicionales as $key_adic => $value_adic){
			$observacion .= "Id: " . $value_adic["id"] . " - Nombre: " . $value_adic["nombre"] . " - Número: " . $value_adic["numero"] . "\r\n";
		}
	}
	
	
	if ($data["debug"]==99){

		$resp = array(
			"data_id_cliente" => $data_id_cliente,
			"data_noperacion" => $data_noperacion,
			"data_productos" => $data_productos,
			"data_adicionales" => $data_adicionales,
			"data_adicionales_codigo" => $data_adicionales_codigo
		);

		$res = array("data" => $resp, "status" => 200, "message" => "DEBUG");
  		echo json_encode($res);
  		exit;
		
	}
	

	
	
	
	$sql = "EXEC SP_VW_Cbtes_Generar ?, ?, ?, ?, ?, ?";
	// 'trans web', fecha, hora, id_cliente, importe, observacion
	$params = array($data_noperacion, date('Ymd'), date('His'), $data_id_cliente, $importe_total, $observacion);
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	logError("Error sql 754985", __LINE__);
			$res = array("data" => "", "status" => 400, "message" => "Error 754985");
  			echo json_encode($res);
  			exit;
  	    }
  	}else{


	}
	
	
/*	
	// 5 dias antes de fin de mes pasa al mes siguiente
  	$dia_actual = date('j');
  	$dia_fin = date('t');
  	$dia_dif = $dia_fin - 5;
  	if ($dia_actual > $dia_dif){
  		// se pasa al mes siguiente
  		$nextmonth = mktime(0, 0, 0, date("m")+1, 1, date("Y"));
  		$desde = date('Ym', $nextmonth) . "01";
  		$hasta = date('Ymt', $nextmonth);
  	}else{
  		$desde = date('Ym') . "01";
  		$hasta = date('Ymt');
  	}
*/
	
	$item = 1;
	foreach($data_productos as $key => $value){
		
		$prod_desde = $value["desde"];
		$prod_hasta = $value["hasta"];
	
		$sql = "EXEC SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ?, ? ";
		//'trans web', item (1,2,3,), id_producto, nota, importe, F_desde, F_hasta, id_cliente
		$params = array($data_noperacion, $item, $value["codigo"], '', $value["importe"], $prod_desde, $prod_hasta, $data_id_cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
	  	if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 754988", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 754988");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	}else{
	
	
		}
	
		$item++;
		
	}
	

	
  	$sql = "EXEC SP_VW_Pago_Generar ?, ?, ?, ?, ?, ?, ? ";
  	//'trans web',item (1,2,3,),id_tipo_val,id_tarjeta,'trans pago',nota,importe_pago
  	$params = array($data_noperacion, 1, 'DB', '', 0, '', $importe_total);
  	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	logError("Error sql 754986", __LINE__);
			$res = array("data" => "", "status" => 400, "message" => "Error 754986");
  			echo json_encode($res);
  			exit;
  	    }
  	}else{


	}
	

	$sql = "EXEC SP_VW_Confirmar ? ";
	// 'trans web'
	$params = array($data_noperacion);
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	logError("Error sql 754987", __LINE__);
			$res = array("data" => "", "status" => 400, "message" => "Error 754987");
  			echo json_encode($res);
  			exit;
  	    }
  	}else{


	}




	// ============================================
	//socios adicionales para los packs 4x3 etc
	// ============================================
	if (is_array($data_adicionales))
	foreach($data_adicionales as $key => $value){
		
		$sql = "EXEC SP_VW_Cbtes_Generar ?, ?, ?, ?, ?, ?";
		// 'trans web', fecha, hora, id_cliente, importe, observacion
		$params = array($data_noperacion, date('Ymd'), date('His'), $value["id"], 0, $observacion);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		$sql = "EXEC SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ?, ? ";
		//'trans web', item (1,2,3,), id_producto, nota, importe, F_desde, F_hasta, id_cliente
		$params = array($data_noperacion, 1, $data_adicionales_codigo, '', 0, $prod_desde, $prod_hasta, $value["id"]);
		$stmt = sqlsrv_query( $conn, $sql, $params);

		$sql = "EXEC SP_VW_Pago_Generar ?, ?, ?, ?, ?, ?, ? ";
		//'trans web',item (1,2,3,),id_tipo_val,id_tarjeta,'trans pago',nota,importe_pago
		$params = array($data_noperacion, 1, 'DB', '', 0, '', 0);
		$stmt = sqlsrv_query( $conn, $sql, $params);

		$sql = "EXEC SP_VW_Confirmar ? ";
		// 'trans web'
		$params = array($data_noperacion);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	}
	$res = array("data" => "", "status" => 200, "message" => "");
  	echo json_encode($res);
  	exit;



}











# ==================================================================================
# 
# Ingreso de Pago SPS Decidir
# setTempUserPaymentSPS=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"} toda la info de decidir
# 
# ==================================================================================

if ($_POST["setTempUserPaymentSPS"]==1){

	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	
	$data_resultado = $data["resultado"];
	$data_noperacion = $data["noperacion"];
	
	if ($data_resultado == "APROBADA"){
		
		$sql = "select top 1 * from Clientes_Temp where Nro_Trans_Pago=? ";
		$params = array($data_noperacion);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 465465");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
		
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);

			$Id_Cliente_Temp = $row["Id_Cliente_Temp"];

			$Importe_CS = $row["Importe_CS"];
			$Importe_GA = $row["Importe_GA"];
			$Importe_GE = $row["Importe_GE"];
			
			$Importe_TOTAL = $Importe_CS + $Importe_GA + $Importe_GE;
			
			
			// cliente para recibos de clientes_temp
			$sql = "SELECT dbo.CF_xParam('Id_ClienteNue_Web') as id_cliente_cbtes";
			$stmt = sqlsrv_query( $conn, $sql, $params);
			if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6746634");
		  			echo json_encode($res);
		  			exit;
		  	    }
			}else{
				$row = GetLastResultAssoc($stmt);
				$id_cliente_cbtes = $row["id_cliente_cbtes"];
			}
			
			
			//$sql = "exec SP_VW_Cbtes_Generar ?, ?, ?, ?, ? ";
			$sql = "exec CP_Cbtes_Alta_Online ?, ?, ?, ? ";
			
			// @LOTE VARCHAR(20), @Fecha CHAR(8), @Hora CHAR(6), @Id_Cliente INT, @Importe DECIMAL(12,2)
			$params = array($data_noperacion, date('Ymd'), $id_cliente_cbtes, $Importe_TOTAL);
			$stmt = sqlsrv_query( $conn, $sql, $params);
		  	if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6746634");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}else{
		  	
				$row = GetLastResultAssoc($stmt);
				$Id_Trans = $row["Id_Trans"];

				$item = 1;
				if ($Id_Trans>0){
					
					// 5 dias antes de fin de mes pasa al mes siguiente
					$dia_actual = date('j');
					$dia_fin = date('t');
					$dia_dif = $dia_fin - 5;
					if ($dia_actual > $dia_dif){
						// se pasa al mes siguiente
						$nextmonth = mktime(0, 0, 0, date("m")+1, 1, date("Y"));
						$desde = date('Ym', $nextmonth) . "01";
						$hasta = date('Ymt', $nextmonth);
					}else{
						$desde = date('Ym') . "01";
						$hasta = date('Ymt');
					}
				
					// ITEM 1 - CUOTA SOCIAL (CS)
					//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
					$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
					
					// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
					$params = array($data_noperacion, $item, 'CS', '', $Importe_CS, $desde, $hasta, 1, $id_cliente_cbtes);
					$stmt = sqlsrv_query( $conn, $sql, $params);
					$item++;
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 3246575");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
					
					// ITEM 2 - GASTOS ADMINISTRATIVOS (GASTOS ADM. INDIVIDUAL)
					if ($Importe_GA>0){
					
						//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
						$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
						
						// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
						$params = array($data_noperacion, $item, $id_producto_gastos_administrativos, '', $Importe_GA, $desde, $hasta, 1, $id_cliente_cbtes);
						$stmt = sqlsrv_query( $conn, $sql, $params);
						$item++;
					  	if( $stmt === false ) {
					  	    if(($errors = sqlsrv_errors()) != null){
					  	    	logError("Error: " . $errors[0]["message"], __LINE__);
					  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
					  			echo json_encode($res);
					  			exit;
					  	    }else{
					  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6745643");
					  			echo json_encode($res);
					  			exit;
					  	    }
					  	}
					}
					

				
					// ITEM 3 - GASTOS DE ENVIO (GTO. ENVÍO CARNET)
					if ($Importe_GE>0){
						
						//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
						$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
						
						// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
						$params = array($data_noperacion, $item, 'SOCI0242', '', $Importe_GE, $desde, $hasta, 1, $id_cliente_cbtes);
						$stmt = sqlsrv_query( $conn, $sql, $params);
						$item++;
					  	if( $stmt === false ) {
					  	    if(($errors = sqlsrv_errors()) != null){
					  	    	logError("Error: " . $errors[0]["message"], __LINE__);
					  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
					  			echo json_encode($res);
					  			exit;
					  	    }else{
					  	    	$res = array("data" => "", "status" => 400, "message" => "Error 645763463");
					  			echo json_encode($res);
					  			exit;
					  	    }
					  	}
					}
					

					
					// FINALIZAR - GENERAR PAGO
  					
  					//$sql = "exec SP_VW_Pago_Generar ?, ?, ?, ?, ?, ?, ? ";
  					$sql = "exec CP_Cbtes_Pago_Online ?, ?, ?, ?, ?, ?, ? ";
  					
  					// @Lote VARCHAR(20), @Item INT, @Id_Tipo_Val CHAR(4), @Id_Tarjeta VARCHAR(10), @TransPago VARCHAR(15), @Nota VARCHAR(100), @ImportePago DECIMAL(12,2)
  					$params = array($data_noperacion, 1, 'DB', '', 0, '', $Importe_TOTAL);
  					$stmt = sqlsrv_query( $conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
		  			
		  			
					
					// FINALIZAR - CONFIRMAR PAGO
  					//$sql = "exec SP_VW_Confirmar ? ";
  					$sql = "CP_Cbtes_Confirmar_Online ? ";
  					  					
  					// @Lote VARCHAR(20)
  					$params = array($data_noperacion);
  					$stmt = sqlsrv_query( $conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
				  	
				  	
				  	
				  	
					
		  			
					
			  		// ACTUALIZO EL ESTADO DEL CLIENTE TEMP
			  		$sql = "UPDATE Clientes_Temp set Id_Estado_Solicitud='P', Flag_Pago='P', Id_Trans=? where Id_Cliente_Temp=?";
					$params = array($Id_Trans, $Id_Cliente_Temp);
			  		$stmt = sqlsrv_query($conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5345435");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
				
				}else{
				
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 464363 Id_Trans");
		  			echo json_encode($res);
		  			exit;
				
				}








		  		
		  		$resp = array("data" => array(), "status" => 200, "message" => "");
		  		echo json_encode($resp);
		  		exit;			
				
			}
			
			
			
			
			
			

			
			
			
			
			

		}
		
		
		
		$resp = array("data" => $row, "status" => 200, "message" => "Transaccion NO Aprobada");
		echo json_encode($resp);
		exit;
	
	}
	
	
	
	// update Clientes_Temp -> nro de transaccion aprobada ?







	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}














# ==================================================================================
# 
# Ingreso de Pago usuario nuevo (clientes_temp)
# setTempUserPayment=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"} toda la info de decidir
# 
# ==================================================================================

if ($_POST["setTempUserPayment"]==1){

	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}

	$data_noperacion = $data["noperacion"];
	if (!$data_noperacion){
	  	$res = array("data" => "", "status" => 400, "message" => "Error falta nro operacion 475673");
	  	echo json_encode($res);
	  	exit;
	}
	
	// Configurar $cuotas_mas  mas abajo !

		
		$sql = "select top 1 * from Clientes_Temp where Nro_Trans_Pago=? ";
		$params = array($data_noperacion);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 465465");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
			
	  		$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
			
			$Id_Cliente_Temp 				= $row["Id_Cliente_Temp"];
			$Debito_Automatico_Id_Tarjeta 	= $row["Debito_Automatico_Id_Tarjeta"];
			$Flag_Interior 					= $row["Flag_Interior"];
			$Importe_CS 					= $row["Importe_CS"];
			$Importe_GA 					= $row["Importe_GA"];
			$Importe_GE 					= $row["Importe_GE"];
			
			// Verifico si existe
			if (!$Id_Cliente_Temp){
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error Temp 655443");
	  			echo json_encode($res);
	  			exit;
			}
			
			// Verifico si ya esta pagado
			if ($row["Flag_Pago"]=="P"){
				$resp = array("data" => $row, "status" => 400, "message" => "Transaccion ya cobrada");
				echo json_encode($resp);
				exit;
			}
			
			
			// Verifico si no hay un cbte con el mismo nro lote
			$sql = "SELECT Id_Trans from Cbtes where Lote=? and id_estado_cbte in (0,2)";
			$params = array('VW:' . $data_noperacion);
			$stmt = sqlsrv_query( $conn, $sql, $params);
			if ( $stmt === false ){
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error 6456546: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 7345756");
		  			echo json_encode($res);
		  			exit;
		  	    }
			}else{
				$row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
				if ($row["Id_Trans"]!=""){
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error ya existe el Cbte 5343453");
		  			echo json_encode($res);
		  			exit;
				}
			}
			
			
			
			
			// ---------------------------------------------------------------------------------------------------------------------
			// Config
			// ---------------------------------------------------------------------------------------------------------------------
			$cuotas_mas = 3;								// cantidad de cuotas a agregar si no se adhiere al debito automatico
			if ($Flag_Interior) $cuotas_mas = 1;			// Si es socio del interior agrega una mas
			// ---------------------------------------------------------------------------------------------------------------------
			
			
			
			$Importe_TOTAL = $Importe_CS + $Importe_GA + $Importe_GE;
			if ($Debito_Automatico_Id_Tarjeta==""){
				$Importe_TOTAL += ($Importe_CS * $cuotas_mas);
			}
			
			
			// cliente para recibos de clientes_temp
			$sql = "SELECT dbo.CF_xParam('Id_ClienteNue_Web') as id_cliente_cbtes";
			$stmt = sqlsrv_query( $conn, $sql, $params);
			if ( $stmt === false ){
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6746634");
		  			echo json_encode($res);
		  			exit;
		  	    }
			}else{
				$row = GetLastResultAssoc($stmt);
				$id_cliente_cbtes = $row["id_cliente_cbtes"];
			}

			
			//$sql = "exec SP_VW_Cbtes_Generar ?, ?, ?, ?, ? ";
			$sql = "exec CP_Cbtes_Alta_Online ?, ?, ?, ? ";
			
			// @LOTE VARCHAR(20), @Fecha CHAR(8), @Id_Cliente INT, @Importe DECIMAL(12,2)
			$params = array($data_noperacion, date('Ymd'), $id_cliente_cbtes, $Importe_TOTAL);
			$stmt = sqlsrv_query( $conn, $sql, $params);
		  	if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6746634");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}else{
		  	
				$row = GetLastResultAssoc($stmt);
				
				$Id_Trans = $row["Id_Trans"];

				$item = 1;
				if ($Id_Trans>0){
					
					// 5 dias antes de fin de mes pasa al mes siguiente
					$dia_actual = date('j');
					$dia_fin = date('t');
					$dia_dif = $dia_fin - 5;
					if ($dia_actual > $dia_dif){
						// se pasa al mes siguiente
						$nextmonth = mktime(0, 0, 0, date("m")+1, 1, date("Y"));
						$desde = date('Ym', $nextmonth) . "01";
						$hasta = date('Ymt', $nextmonth);
					}else{
						$desde = date('Ym') . "01";
						$hasta = date('Ymt');
					}
				
					// ITEM 1 - CUOTA SOCIAL (CS)
					//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
					$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
					
					// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
					$params = array($data_noperacion, $item, 'CS', '', $Importe_CS, $desde, $hasta, 1, $id_cliente_cbtes);
					$stmt = sqlsrv_query( $conn, $sql, $params);
					$item++;
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 3246575");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
					
				  	// ---------------------------------------------------------------------------------------------------------------------
				  	// VELEZ
				  	// Si no se adhiere al debito automatico cobrar 4 cuotas (3 mas) / interior 1 mas
				  	// ---------------------------------------------------------------------------------------------------------------------
				  	if ($Debito_Automatico_Id_Tarjeta==""){
				  	
					  	$oDesde = $desde;
					  	$oHasta = $hasta;
					  	
					  	for ($i=0; $i<$cuotas_mas; $i++){
					  	
					  		// Calcular proximo mes...
							$nuevaFecha = strtotime($oDesde . " +1 month");
							$oDesde = date('Ym', $nuevaFecha) . "01";
							$oHasta = date('Ymt', $nuevaFecha);
					  		
							// ITEM X - CUOTA SOCIAL (CS)
							$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
							
							// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
							$params = array($data_noperacion, $item, 'CS', '', $Importe_CS, $oDesde, $oHasta, 1, $id_cliente_cbtes);
							$stmt = sqlsrv_query( $conn, $sql, $params);
							$item++;
						  	if( $stmt === false ) {
						  	    if(($errors = sqlsrv_errors()) != null){
						  	    	logError("Error: " . $errors[0]["message"], __LINE__);
						  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
						  			echo json_encode($res);
						  			exit;
						  	    }else{
						  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4643665");
						  			echo json_encode($res);
						  			exit;
						  	    }
						  	}

					  	}

				  	}
					
					// ITEM 2 - GASTOS ADMINISTRATIVOS (GASTOS ADM. INDIVIDUAL)
					if ($Importe_GA>0){
					
						//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
						$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
						
						// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
						$params = array($data_noperacion, $item, $id_producto_gastos_administrativos, '', $Importe_GA, $desde, $hasta, 1, $id_cliente_cbtes);
						$stmt = sqlsrv_query( $conn, $sql, $params);
						$item++;
					  	if( $stmt === false ) {
					  	    if(($errors = sqlsrv_errors()) != null){
					  	    	logError("Error: " . $errors[0]["message"], __LINE__);
					  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
					  			echo json_encode($res);
					  			exit;
					  	    }else{
					  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6745643");
					  			echo json_encode($res);
					  			exit;
					  	    }
					  	}
					}
					

				
					// ITEM 3 - GASTOS DE ENVIO (GTO. ENVÍO CARNET)
					if ($Importe_GE>0){
						
						//$sql = "exec SP_VW_Items_Generar ?, ?, ?, ?, ?, ?, ? ";
						$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
						
						// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
						$params = array($data_noperacion, $item, '4510', '', $Importe_GE, $desde, $hasta, 1, $id_cliente_cbtes);
						$stmt = sqlsrv_query( $conn, $sql, $params);
						$item++;
					  	if( $stmt === false ) {
					  	    if(($errors = sqlsrv_errors()) != null){
					  	    	logError("Error: " . $errors[0]["message"], __LINE__);
					  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
					  			echo json_encode($res);
					  			exit;
					  	    }else{
					  	    	$res = array("data" => "", "status" => 400, "message" => "Error 645763463");
					  			echo json_encode($res);
					  			exit;
					  	    }
					  	}
					}
					

					
					// FINALIZAR - GENERAR PAGO
  					
  					//$sql = "exec SP_VW_Pago_Generar ?, ?, ?, ?, ?, ?, ? ";
  					$sql = "exec CP_Cbtes_Pago_Online ?, ?, ?, ?, ?, ?, ? ";
  					
  					// @Lote VARCHAR(20), @Item INT, @Id_Tipo_Val CHAR(4), @Id_Tarjeta VARCHAR(10), @TransPago VARCHAR(15), @Nota VARCHAR(100), @ImportePago DECIMAL(12,2)
  					$params = array($data_noperacion, 1, 'DB', '', 0, '', $Importe_TOTAL);
  					$stmt = sqlsrv_query( $conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
		  			
		  			
					
					// FINALIZAR - CONFIRMAR PAGO
  					//$sql = "exec SP_VW_Confirmar ? ";
  					$sql = "CP_Cbtes_Confirmar_Online ? ";
  					  					
  					// @Lote VARCHAR(20)
  					$params = array($data_noperacion);
  					$stmt = sqlsrv_query( $conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
				  	
				  	
				  	

					
			  		// ACTUALIZO EL ESTADO DEL CLIENTE TEMP
			  		$sql = "UPDATE Clientes_Temp set Flag_Pago='P', Id_Trans=? , Id_Estado_Solicitud='P' where Id_Cliente_Temp=?";
					$params = array($Id_Trans, $Id_Cliente_Temp);
					//log_query($sql, $params);
			  		$stmt = sqlsrv_query($conn, $sql, $params);
				  	if( $stmt === false ) {
				  	    if(($errors = sqlsrv_errors()) != null){
				  	    	logError("Error: " . $errors[0]["message"], __LINE__);
				  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
				  			echo json_encode($res);
				  			exit;
				  	    }else{
				  	    	$res = array("data" => "", "status" => 400, "message" => "Error 5345435");
				  			echo json_encode($res);
				  			exit;
				  	    }
				  	}
				
				}else{
				
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 464363 Id_Trans");
		  			echo json_encode($res);
		  			exit;
				
				}








		  		
		  		$resp = array("data" => array(), "status" => 200, "message" => "");
		  		echo json_encode($resp);
		  		exit;			
				
			}
			
			
			
			
			
			

			
			
			
			
			

		}
		
		
		
		$resp = array("data" => $row, "status" => 200, "message" => "Transaccion NO Aprobada");
		echo json_encode($resp);
		exit;
	

	
	
	
	// update Clientes_Temp -> nro de transaccion aprobada ?





	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}



















# ==================================================================================
# 
# Ingreso de Pagos de productos en general
# setPaymentProd=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_cliente":"1"} toda la info de ...
# 
# ==================================================================================

if ($_POST["setPaymentProd"]==1){
	
	
	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	$data_id_cliente = $data["id_cliente"];
	$data_noperacion = $data["noperacion"];
	$data_productos = $data["productos"];
	$data_email  = $data["email"];
	
	// verificar noperacion / id_cliente / productos
	if (!$data_id_cliente || !$data_noperacion || !$data_productos){
	  	$res = array("data" => "", "status" => 400, "message" => "Error faltan datos 846548");
	  	echo json_encode($res);
	  	exit;
	}
	
	$importe_total = 0;
	foreach ($data_productos as $key => $value){
		$importe_total += $value["importe"] * $value["cantidad"];
	}
	
	// verificar importe_total
	if ($importe_total<1){
	  	$res = array("data" => "", "status" => 400, "message" => "Error importe total 653434");
	  	echo json_encode($res);
	  	exit;
	}







			
			//$sql = "exec SP_VW_Cbtes_Generar ?, ?, ?, ?, ? ";
			$sql = "exec CP_Cbtes_Alta_Online ?, ?, ?, ? ";
			
			// @LOTE VARCHAR(20), @Fecha CHAR(8), @Id_Cliente INT, @Importe DECIMAL(12,2)
			$params = array($data_noperacion, date('Ymd'), $data_id_cliente, $importe_total);
			$stmt = sqlsrv_query( $conn, $sql, $params);
		  	if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 6746634");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}else{
		  	
				$row = GetLastResultAssoc($stmt);
				$Id_Trans = $row["Id_Trans"];

			}
			
			
			if (!$Id_Trans){
			
		  	   	$res = array("data" => "", "status" => 400, "message" => "Error 464363 Id_Trans");
		  		echo json_encode($res);
		  		exit;
			
			}
			

			
			
			// ITEMS
			
			$item = 1;
			foreach ($data_productos as $key => $value){
			
				$desde = str_replace("-", "", $value["desde"]);
				$hasta = str_replace("-", "", $value["hasta"]);
	  			
	  			$sql = "exec CP_Cbtes_Items_Alta_Online ?, ?, ?, ?, ?, ?, ?, ?, ? ";
	  			
	  			// @LOTE VARCHAR(20), @Item INT, @Id_Producto CHAR(14), @Nota VARCHAR(200), @Importe DECIMAL(12,2), @Desde DATETIME, @Hasta DATETIME, @pCantidad DECIMAL(12,4), @Id_Cliente INT
	  			$params = array($data_noperacion, $item, $value["id_producto"], '', $value["importe"], $desde, $hasta, $value["cantidad"], $data_id_cliente);
	  			$stmt = sqlsrv_query( $conn, $sql, $params);
	  		  	if( $stmt === false ) {
	  		  	    if(($errors = sqlsrv_errors()) != null){
	  		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  		  			echo json_encode($res);
	  		  			exit;
	  		  	    }else{
	  		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 3246575");
	  		  			echo json_encode($res);
	  		  			exit;
	  		  	    }
	  		  	}

	  			$item++;
				
			}
			
			


					
			// GENERAR PAGO
  			
  			$sql = "exec CP_Cbtes_Pago_Online ?, ?, ?, ?, ?, ?, ? ";
  			
  			// @Lote VARCHAR(20), @Item INT, @Id_Tipo_Val CHAR(4), @Id_Tarjeta VARCHAR(10), @TransPago VARCHAR(15), @Nota VARCHAR(100), @ImportePago DECIMAL(12,2)
  			$params = array($data_noperacion, 1, 'DB', '', 0, '', $importe_total);
  			$stmt = sqlsrv_query( $conn, $sql, $params);
		  	if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}
  			
  			
			
			// FINALIZAR - CONFIRMAR PAGO
			
  			$sql = "CP_Cbtes_Confirmar_Online ? ";
  			  					
  			// @Lote VARCHAR(20)
  			$params = array($data_noperacion);
  			$stmt = sqlsrv_query( $conn, $sql, $params);
		  	if( $stmt === false ) {
		  	    if(($errors = sqlsrv_errors()) != null){
		  	    	logError("Error: " . $errors[0]["message"], __LINE__);
		  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
		  			echo json_encode($res);
		  			exit;
		  	    }else{
		  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4645634");
		  			echo json_encode($res);
		  			exit;
		  	    }
		  	}



		// Todo ok
  		
  		$resp = array("data" => array(), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
		  		
		  			
				



	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;
	
	

}









# ==================================================================================
# 
# Valida el nro de tarjeta o cbu
# tarjeta_validar=1
# 
# ==================================================================================
# 
# data (POST)
# 	{"id_tarjeta":"02", "tar_nro":"12345"}
# 
# ==================================================================================
if ($_POST["tarjeta_validar"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	
	$data_id_tarjeta = trim($data["id_tarjeta"]);
	$data_nro_tarjeta = trim($data["tar_nro"]);
	
	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
		echo json_encode($res);
		exit;
	}
	
	// verifica si ingresa el dato id_cliente - proceso principal
	if ($data_id_tarjeta && $data_nro_tarjeta){
		
		$sql = "select dbo.CF_Tarjeta_Validar(?, ?)";
		$params = array($data_id_tarjeta, $data_nro_tarjeta);
	  	$stmt = sqlsrv_query( $conn, $sql, $params);
		if( $stmt === false ) {
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("Error: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	logError("Error sql 8573987", __LINE__);
				$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{
		
			if ( sqlsrv_fetch( $stmt ) ){
				$res = sqlsrv_get_field( $stmt, 0);
			}

	  	}
		
  		$resp = array("data" => array("result" => $res), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
		
	}
	
	
	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}











# ==================================================================================
# 
# Listado de Tarjetas de credito / cuentas
# Valores_Tarjetas_Cred=1
# 
# ==================================================================================
# 
# data (POST)
# 	{}
# 
# ==================================================================================

if ($_POST["Valores_Tarjetas_Cred"]==1){

	// no hace falta
	//$data = json_decode($_POST["data"], true);
	//$jsonerror = json_last_error();

	// verifica si el json es valido
	//if ($jsonerror){
	//	$res = array("data" => "", "status" => 500, "message" => "Invalid JSON");
	//	echo json_encode($res);
	//	exit;
	//}
	
	$sql = "select Id_Tarjeta, Descripcion from Valores_Tarjetas_Cred";
	$params = array();
	$stmt = sqlsrv_query( $conn, $sql, $params);
	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	logError("Error: " . $errors[0]["message"], __LINE__);
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	logError("Error sql 8573987", __LINE__);
			$res = array("data" => "", "status" => 400, "message" => "Error 8573987");
  			echo json_encode($res);
  			exit;
  	    }
	}else{
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
			$tarjetas[] = $row;
		}
  		$resp = array("data" => array("tarjetas" => $tarjetas), "status" => 200, "message" => "");
  		echo json_encode($resp);
  		exit;
	}



	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;

}










# ==================================================================================
# 
# Datos para modificar inscripcion 
# $Valores_Monedas=1
# 
# ==================================================================================
# 
# data (POST)
# 	{todos los datos}	ToDo: ver campos
# 
# ==================================================================================

if ($_POST["Valores_Monedas"]==1){

	$sql = "select Id_Moneda, Cotizacion from Valores_Monedas";
	$params = array();
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573988 " . __LINE__);
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
  	
  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
  			$Valores_Monedas[$row["Id_Moneda"]] = $row["Cotizacion"];
  		}
  		
      	$res = array("data" => array("Valores_Monedas" => $Valores_Monedas), "status" => 200, "message" => "");
  		echo json_encode($res);
  		exit;
  	
  	}
  	
	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;
	
}






# ==================================================================================

?>