<?
/*
- buscarCliente					buscador de socios para popup web (abonos)
- getClientes
- getCbtes_Tipos

*/



/* clever-autodoc
<clever-autodoc>
	<file name="tablas.php">
		<name>tablas.php</name>
		<last_update>12/06/2019 17:10Hs</last_update>
		<updates>
			<item>
				<date>12/06/2019 17:10Hs</date>
				<description>Creacion</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getClientes</name>
				<description>Devuelve un listado de Clientes</description>
			</item>
			<item>
				<name>getCbtes_Tipos</name>
				<description>Devuelve un listado de Tipos de Comprobantes</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/


// Buscador por apellido o documento o nro de socio
if ($_POST["buscarCliente"]==1){


	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();
	$buscar = $data["buscar"];
	$pFiltro = $data["filtro"];


	// verifica si el json es valido
	if ($jsonerror){
		$res = array("data" => "", "status" => 500, "message" => "JSON invalido");
		echo json_encode($res);
		exit;
	}

	if ($buscar){
	

	
		$maximo = 15;
		$sql = "select top " . ($maximo+10) . " 
						c1.Id_Cliente, c1.Razon_Social, c1.id_cliente_ref, 
						c1.Doc_Nro, c1.Id_Cliente_Externo,
						c2.Id_Cliente as id_empresa, c2.Razon_Social as empresa
				from Clientes c1
				left join Clientes c2 on c1.Id_Cliente_Ref=c2.Id_Cliente
				where 
					c1.activo=1 
					and c1.id_tipo_cli BETWEEN 1 AND 12
				and 
					(
						c1.doc_nro = '" . (int)$buscar . "' 
						or
						c1.Id_Cliente_Externo = '" . (int)$buscar . "' 
					)
				";
		if (trim($pFiltro)!="") $sql .= " and " . $pFiltro . " ";
		//if ($id_empresa) $sql .= " and c1.id_cliente_ref='" . $id_empresa . "' ";
		$sql .= " order by c1.Razon_Social ";
		
		
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
	  	if( $stmt === false ) {
	  	
	  		//echo $sql;
	  	
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	//print_r($errors);
	  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"] . " " . $sql)   );
	  			echo json_encode($res);
	  			exit;
	  	    }else{
	  	    	$res = array("data" => "", "status" => 400, "message" => "Error 4643634");
	  			echo json_encode($res);
	  			exit;
	  	    }
	  	    
	  	}else{

			$counter = 1;
	  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){

	  			$rows[] = array(
	  				"Id_Cliente" => $row["Id_Cliente"], 
	  				"Razon_Social" => $row["Razon_Social"], 
	  				"Doc_Nro" => $row["Doc_Nro"], 
	  				"Id_Cliente_Externo" => $row["Id_Cliente_Externo"], 
	  				"id_empresa" => $row["id_empresa"], 
	  				"empresa" => $row["empresa"]);
				if ($counter>($maximo-1)){
					$rows[] = array("Id_Cliente" => "", "Razon_Social" => "Tamaño máximo de resultados exedido.", "Id_Cliente_Externo" => "");
					break;
				}
				$counter++;
	  		}
	  		if ($counter==1){

			}
	  		$res = array("data" => array("clientes" => $rows), "status" => 200, "message" => "");
	  		echo json_encode($res);
	  		exit;

		}

		exit;
		
	}



	$res = array("status" => 400, "message" => "Error 658734589");
	echo json_encode($res);
	exit;

}






/* clever-autodoc
<clever-autodoc>
	<function name="getClientes">
		<name>getClientes</name>
		<description>Devuelve un listado de Clientes</description>
		<parameters>
			<item>
				<name>pFiltro</name>
				<type>VARCHAR(5000)</type>
				<description>Filtro sobre la tabla de Clientes (Ej. "WHERE Activo = 1 AND Id_Tipo_Cli = 5")</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Cliente</name>
					<type>INT</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Activo</name>
					<type>TINYINT</type>
					<description>0: Inactivo. 1: Activo</description>
				</item>
				<item>
					<name>Id_Cliente_Externo</name>
					<type>VARCHAR(14)</type>
					<description>Numero de Socio</description>
				</item>
				<item>
					<name>Razon_Social</name>
					<type>VARCHAR(100)</type>
					<description>Razon Social/Apellido y Nombre del Cliente</description>
				</item>
				<item>
					<name>Apellido</name>
					<type>VARCHAR(100)</type>
					<description>Apellido del Cliente</description>
				</item>
				<item>
					<name>Nombre</name>
					<type>VARCHAR(100)</type>
					<description>Apellido del Cliente</description>
				</item>
				<item>
					<name>Id_Tipo_Doc</name>
					<type>CHAR(3)</type>
					<description>Codigo de Tipo de Documento</description>
				</item>
				<item>
					<name>Doc_Nro</name>
					<type>BIGINT</type>
					<description>Numero de Documento</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getClientes INICIO*/
if ($_POST["getClientes"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getClientes: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pFiltro = $data["pFiltro"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pFiltro){
		
		$sql = "SELECT Id_Cliente, Activo, ISNULL(Id_Cliente_Externo, '') AS Id_Cliente_Externo, 
				ISNULL(Razon_Social, '') AS Razon_Social, ISNULL(Apellido, '') AS Apellido, ISNULL(Nombre, '') AS Nombre, 
				ISNULL(Id_Tipo_Doc, '') AS Id_Tipo_Doc, ISNULL(Doc_Nro, 0) AS Doc_Nro 
				FROM Clientes " . $pFiltro;
		//$params = array($pStoredProcedure);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getClientes: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getClientes: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{			
			//Resultado consulta SQL OK
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$res[] = $row;
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;						
		}

	}else{
		logError("getClientes: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getClientes FIN*/

/* clever-autodoc
<clever-autodoc>
	<function name="getCbtes_Tipos">
		<name>getCbtes_Tipos</name>
		<description>Devuelve un listado de Tipos de Comprobantes</description>
		<parameters>
			<item>
				<name>pFiltro</name>
				<type>VARCHAR(5000)</type>
				<description>Filtro sobre la tabla de Cbtes_Tipos (Ej. "WHERE Activo = 1 AND Compromete_Factura = 1")</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Tipo_Cbte</name>
					<type>CHAR(4)</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Activo</name>
					<type>TINYINT</type>
					<description>0: Inactivo. 1: Activo</description>
				</item>
				<item>
					<name>Id_Sucursal</name>
					<type>SMALLINT</type>
					<description>Codigo de Sucursal</description>
				</item>
				<item>
					<name>Descripcion</name>
					<type>VARCHAR(100)</type>
					<description>Nombre de Tipo de Comprobante</description>
				</item>
				<item>
					<name>Letra</name>
					<type>CHAR(1)</type>
					<description>Letra del Tipo de Comprobante</description>
				</item>
				<item>
					<name>Prox_Nro</name>
					<type>INT</type>
					<description>Numero Proximo a asignar al proximo Comprobante</description>
				</item>
				<item>
					<name>Descrip_Corta</name>
					<type>CHAR(4)</type>
					<description>Descripcion Corta</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getCbtes_Tipos INICIO*/
if ($_POST["getCbtes_Tipos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getCbtes_Tipos: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	$pFiltro = $data["pFiltro"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pFiltro){
		
		$sql = "SELECT Id_Tipo_Cbte, Activo, ISNULL(Id_Sucursal, 0) AS Id_Sucursal, ISNULL(Descripcion, '') AS Descripcion, 
				ISNULL(Letra, '') AS Letra, ISNULL(Prox_Nro, 1) AS Prox_Nro, ISNULL(Descrip_Corta, '') AS Descrip_Corta
				FROM Cbtes_Tipos " . $pFiltro;
		//$params = array($pStoredProcedure);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			//Verifica si se trata de un error de SQL
	  	    if(($errors = sqlsrv_errors()) != null){
	  	    	logError("getCbtes_Tipos: Error Interno SQL Server: " . $errors[0]["message"], __LINE__);
	  	    	$res = array("data" => "", "status" => 403, "message" => ("Error: " . $errors[0]["message"]));
	  			echo json_encode($res);
	  			exit;
	  	    }else{
				logError("getCbtes_Tipos: Error sin descripcion", __LINE__);
	  	    	$res = array("data" => "", "status" => 405, "message" => "Error sin descripcion");
	  			echo json_encode($res);
	  			exit;
	  	    }
		}else{			
			//Resultado consulta SQL OK
			while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
				$res[] = $row;
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;						
		}

	}else{
		logError("getCbtes_Tipos: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getCbtes_Tipos FIN*/
?>