<?
/*
<clever-autodoc>
	<file name="ptossrv.php">
		<name>ptossrv.php</name>
		<last_update>22/02/2019 15:52Hs</last_update>
		<updates>
			<item>
				<date>22/02/2019 15:52Hs</date>
				<description>Se formateo la documentacion en XML</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getProductosPreciosElegir</name>
				<description>Llama al Stored Procedure: CP_Browse_Productos_Precios_Elegir para retornar el Browse del Productos con sus precios</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/*
<clever-autodoc>
	<function name="getProductosPreciosElegir">
		<name>getProductosPreciosElegir</name>
		<description>Llama al Stored Procedure: CP_Browse_Productos_Precios_Elegir para retornar el Browse del Productos con sus precios</description>
		<parameters>
			<item>
				<name>pId_Cliente</name>
				<type>INT</type>
				<description>Id_Cliente del cual se quieren buscar los precios disponibles para los productos</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>			
				<item>
					<name>Codigo</name>
					<type>VARCHAR(14)</type>
					<description>Codigo del Producto (Id_Producto)</description>
				</item>
				<item>
					<name>Descripcion_Producto</name>
					<type>VARCHAR(150)</type>
					<description>Descripcion del Producto</description>
				</item>
				<item>
					<name>Precio_Sin_Iva</name>
					<type>DECIMAL(13,4)</type>
					<description>Precio del Producto SIN IVA</description>
				</item>
				<item>
					<name>Precio_Con_Iva</name>
					<type>DECIMAL(13,4)</type>
					<description>Precio del Producto CON IVA</description>
				</item>
				<item>
					<name>Stock_Fisico</name>
					<type>DECIMAL(19,4)</type>
					<description>Cantidad en Stock Fisico</description>
				</item>
				<item>
					<name>Stock_Pedido</name>
					<type>DECIMAL(19,4)</type>
					<description>Siempre cero</description>
				</item>
				<item>
					<name>Stock_Orden_Compra</name>
					<type>DECIMAL(19,4)</type>
					<description>Siempre cero</description>
				</item>
				<item>
					<name>Familia</name>
					<type>VARCHAR(35)</type>
					<description>Familia a la que pertenece el producto</description>
				</item>
				<item>
					<name>Codigo_Externo</name>
					<type>VARCHAR(40)</type>
					<description>Codigo Externo del Producto</description>
				</item>
				<item>
					<name>Descripcion_Reducida</name>
					<type>VARCHAR(100)</type>
					<description>Descripcion Reducida del Producto</description>
				</item>
				<item>
					<name>Presentacion_Codigo</name>
					<type>VARCHAR(10)</type>
					<description>Codigo del Tipo de Presentacion (Prod_Present)</description>
				</item>
				<item>
					<name>Presentacion_Descripcion</name>
					<type>VARCHAR(50)</type>
					<description>Nombre del tipo de presentacion</description>
				</item>
				<item>
					<name>Foto_Grande</name>
					<type>VARCHAR(255)</type>
					<description>Path de la foto del producto</description>
				</item>
				<item>
					<name>Cantidad</name>
					<type>DECIMAL(13,4)</type>
					<description>Cantidad de unidades del producto</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getProductosPreciosElegir INICIO*/
if ($_POST["getProductosPreciosElegir"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getProductosPreciosElegir: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}
	
	$pId_Cliente = $data["pId_Cliente"];
	
	//Verifica si los valores enviados en los parametros de Data contiene algun valor
	if ($pId_Cliente){
		
		$sql = "EXEC CP_Browse_Productos_Precios_Elegir ?";
		$params = array($pId_Cliente);
		$stmt = sqlsrv_query( $conn, $sql, $params);
		
		//Verifica si hay algun error al ejecutar la consulta
	  	if( $stmt === false ) {
			sql_error(sqlsrv_errors(), "Error 99754332" , __LINE__, __FILE__ );
		}else{
			//Resultado consulta SQL OK
			while ( sqlsrv_next_result($stmt) ){
				while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
					$res[] = $row;
				}
			}
				
			$res = array("data" => $res, "status" => 200, "message" => "");
			echo json_encode($res);
			exit;
		}
	}else{
		logError("getProductosPreciosElegir: Valores Parametros Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 402, "message" => "Valores Parametros Data Invalido");
		echo json_encode($res);
		exit;
	}
}
/*getProductosPreciosElegir FIN*/
?>