<?
/*
PRODUCTOS:
- getProductos					Lista de productos

*/





/*
<clever-autodoc>
	<file name="ptos.php">
		<name>ptos.php</name>
		<last_update>13/06/2019 09:59Hs</last_update>
		<updates>
			<item>
				<date>13/06/2019 09:59Hs</date>
				<description>Creacion</description>
			</item>
		</updates>
		<functions>
			<item>
				<name>getProductos</name>
				<description>Devuelve un listado de Productos</description>
			</item>
		</functions>
	</file>
</clever-autodoc>
*/



/*
<clever-autodoc>
	<function name="getProductos">
		<name>getProductos</name>
		<description>Devuelve un listado de Productos</description>
		<parameters>
			<item>
				<name>pFiltro</name>
				<type>VARCHAR(5000)</type>
				<description>Filtro sobre la tabla de Productos (Ej. "WHERE Activo = 1 AND Id_Familia = 1")</description>
			</item>
		</parameters>
		<return>
			<status_posibles>
				<item>
					<id>200</id>
					<description>OK</description>
				</item>
				<item>
					<id>400</id>
					<description>Token Invalido</description>
				</item>
				<item>
					<id>401</id>
					<description>JSON Data Invalido</description>
				</item>
				<item>
					<id>402</id>
					<description>Valores Parametros Data Invalido</description>
				</item>
				<item>
					<id>403</id>
					<description>Error Interno SQL Server</description>
				</item>
				<item>
					<id>405</id>
					<description>Error sin descripcion</description>
				</item>
			</status_posibles>
			<data>
				<item>
					<name>Id_Producto</name>
					<type>VARCHAR(14)</type>
					<description>Identificador</description>
				</item>
				<item>
					<name>Activo</name>
					<type>TINYINT</type>
					<description>0: Inactivo. 1: Activo</description>
				</item>
				<item>
					<name>Descripcion_Resumida</name>
					<type>VARCHAR(100)</type>
					<description>Descripcion Resumida del Producto</description>
				</item>
				<item>
					<name>Descripcion_Detallada</name>
					<type>VARCHAR(150)</type>
					<description>Descripcion Detallada del Producto</description>
				</item>
				<item>
					<name>Vendible</name>
					<type>TINYINT</type>
					<description>0: No Vendible. 1: Vendible</description>
				</item>
				<item>
					<name>Id_Familia</name>
					<type>INT</type>
					<description>Codigo de Familia de Producto</description>
				</item>
			</data>
		</return>
	</function>
</clever-autodoc>
*/
/*getProductos INICIO*/



# ==================================================================================
# 
# Datos para modificar inscripcion 
# $getProductos=1
# 
# ==================================================================================
# 
# data (POST)
# 	{todos los datos}	ToDo: ver campos
# 
# ==================================================================================

if ($_POST["getProductos"]==1){

	$data = json_decode($_POST["data"], true);
	$jsonerror = json_last_error();

	//Verifica si en "data" el fomato JSON es valido
	if ($jsonerror){
		logError("getClientes: JSON Data Invalido", __LINE__);
		$res = array("data" => "", "status" => 401, "message" => "JSON Data Invalido");
		echo json_encode($res);
		exit;
	}

	
	$pFiltro = $data["pFiltro"];
	 
	$sql = "SELECT PLP.Id_Lista_Precio, 
				PLP.Descripcion as Lista_Descripcion, 
				PLPI.Id_Producto, 
				ISNULL(P.Descripcion_Resumida, '') AS Descripcion_Resumida, 
				ISNULL(P.Descripcion_Detallada, '') AS Descripcion_Detallada,
				PLPI.Precio, 
				P.Foto_Chica, 
				P.Foto_Grande, 
				PF.Id_Familia, 
				PF.Descripcion as Familia, 
				PF.Foto_Chica as Fam_Foto_Chica, 
				PF.Foto_Grande as Fam_Foto_Grande,
				P.flag_mes,
				P.flag_periodo,
				P.Flag_Periodo_Tipo,
				P.Flag_Periodo_Desde,
				P.Flag_Periodo_Hasta,
				ISNULL(P.Activo,0) AS Activo,
				ISNULL(P.Vendible, 0) AS Vendible
				
				FROM Productos P 
				LEFT JOIN Prod_Listas_Precios_Items PLPI 	on PLPI.Id_Producto		=	P.Id_Producto
				LEFT JOIN Prod_Listas_Precios 		PLP		on PLP.Id_Lista_Precio	=	PLPI.Id_Lista_Precio
				LEFT JOIN Prod_Familias 			PF 		on P.Id_Familia			=	PF.Id_Familia";
				
				
	if(trim($pFiltro)!=""){
		$sql = trim($sql) ." ". $pFiltro;
	}else{
		$sql = trim($sql) . " WHERE PLP.Flag_Web = 1
				and p.activo = 1
				and p.vendible = 1";
	}
	$sql = trim($sql) . "	ORDER BY PLP.Descripcion,PF.Descripcion,P.Descripcion_Resumida";
	
	$params = array();
	$stmt = sqlsrv_query( $conn, $sql, $params);
  	if( $stmt === false ) {
  	    if(($errors = sqlsrv_errors()) != null){
  	    	$res = array("data" => "", "status" => 400, "message" => ("Error: " . $errors[0]["message"]));
  			echo json_encode($res);
  			exit;
  	    }else{
  	    	$res = array("data" => "", "status" => 400, "message" => "Error 8573988 " . __LINE__);
  			echo json_encode($res);
  			exit;
  	    }
  	}else{
  	
  		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)){
  			$productos[$row["Id_Producto"]] = $row;
  			$familias[$row["Id_Familia"]] = $row["Familia"];
  		}
  		
      	$res = array("data" => array("productos" => $productos, "familias" => $familias), "status" => 200, "message" => "");
  		echo json_encode($res);
  		exit;
  	
  	}
  	
	// final de codigo - error
	$res = array("data" => "", "status" => 400, "message" => "Incorrect Data");
	echo json_encode($res);
	exit;
	
}




/*getProductos FIN*/

?>